-- MariaDB dump 10.19  Distrib 10.4.32-MariaDB, for Win64 (AMD64)
--
-- Host: localhost    Database: kalsesv2
-- ------------------------------------------------------
-- Server version	10.4.32-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `banners`
--

DROP TABLE IF EXISTS `banners`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `banners` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `image` varchar(255) NOT NULL,
  `link` varchar(255) DEFAULT NULL,
  `position` varchar(255) NOT NULL DEFAULT 'home',
  `sort_order` int(11) NOT NULL DEFAULT 0,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `banners`
--

LOCK TABLES `banners` WRITE;
/*!40000 ALTER TABLE `banners` DISABLE KEYS */;
INSERT INTO `banners` VALUES (1,'Electronics Sale','http://localhost/kalsesv2/backend/public/storage/uploads/products/b173662e-1fe6-482f-83e8-108703d09809.jpeg','/shop?category=1','home_top',1,1,'2026-02-20 09:14:30','2026-02-20 12:51:33'),(2,'Fashion Sale Up to 50% Off','http://localhost/kalsesv2/backend/public/storage/uploads/products/0f17ea3c-8716-4f03-b2b1-0e59b5f9775c.jpeg','/shop?category=9','home_top',2,1,'2026-02-20 09:14:30','2026-02-20 12:51:33');
/*!40000 ALTER TABLE `banners` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cart_items`
--

DROP TABLE IF EXISTS `cart_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cart_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cart_items_user_id_product_id_unique` (`user_id`,`product_id`),
  KEY `cart_items_product_id_foreign` (`product_id`),
  CONSTRAINT `cart_items_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cart_items_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cart_items`
--

LOCK TABLES `cart_items` WRITE;
/*!40000 ALTER TABLE `cart_items` DISABLE KEYS */;
INSERT INTO `cart_items` VALUES (1,1,1,2,'2026-02-20 09:15:24','2026-02-20 09:15:24');
/*!40000 ALTER TABLE `cart_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `parent_id` bigint(20) unsigned DEFAULT NULL,
  `sort_order` int(11) NOT NULL DEFAULT 0,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `categories_slug_unique` (`slug`),
  KEY `categories_parent_id_foreign` (`parent_id`),
  CONSTRAINT `categories_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `categories` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Electronics','electronics','Electronic devices and gadgets',NULL,NULL,0,1,'2026-02-20 09:14:29','2026-02-20 09:14:29'),(2,'Computers & Laptops','computers-laptops','Computers, laptops and accessories',NULL,NULL,1,1,'2026-02-20 09:14:29','2026-02-20 09:14:29'),(3,'Smartphones & Tablets','smartphones-tablets','Mobile phones and tablets',NULL,NULL,2,1,'2026-02-20 09:14:29','2026-02-20 09:14:29'),(5,'Cameras','cameras','Digital cameras and photography equipment',NULL,NULL,4,1,'2026-02-20 09:14:29','2026-02-20 09:14:29'),(6,'TV & Displays','tv-displays','Televisions and monitors',NULL,NULL,5,1,'2026-02-20 09:14:29','2026-02-20 09:14:29'),(7,'Gaming','gaming','Gaming consoles, games and accessories',NULL,NULL,6,1,'2026-02-20 09:14:29','2026-02-20 09:14:29'),(8,'Home Appliances','home-appliances','Kitchen and home appliances',NULL,NULL,7,1,'2026-02-20 09:14:29','2026-02-20 09:14:29'),(9,'Clothing & Apparel','clothing-apparel','Men and women clothing',NULL,NULL,8,1,'2026-02-20 09:14:29','2026-02-20 09:14:29'),(10,'Shoes & Footwear','shoes-footwear','Shoes, sneakers and boots',NULL,NULL,9,1,'2026-02-20 09:14:29','2026-02-20 09:14:29'),(11,'Sports & Outdoors','sports-outdoors','Sports equipment and outdoor gear',NULL,NULL,10,1,'2026-02-20 09:14:29','2026-02-20 09:14:29'),(13,'Toys & Kids','toys-kids','Toys and products for children',NULL,NULL,12,1,'2026-02-20 09:14:29','2026-02-20 09:14:29'),(14,'Health & Beauty','health-beauty','Health, beauty and personal care',NULL,NULL,13,1,'2026-02-20 09:14:29','2026-02-20 09:14:29'),(15,'Furniture','furniture','Home and office furniture',NULL,NULL,14,1,'2026-02-20 09:14:29','2026-02-20 09:14:29'),(16,'abc','abc',NULL,NULL,NULL,0,1,'2026-02-20 11:20:09','2026-02-20 11:20:09');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `compare_items`
--

DROP TABLE IF EXISTS `compare_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `compare_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `compare_items_user_id_product_id_unique` (`user_id`,`product_id`),
  KEY `compare_items_product_id_foreign` (`product_id`),
  CONSTRAINT `compare_items_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `compare_items_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `compare_items`
--

LOCK TABLES `compare_items` WRITE;
/*!40000 ALTER TABLE `compare_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `compare_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contacts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `subject` varchar(255) NOT NULL,
  `message` text NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `coupons`
--

DROP TABLE IF EXISTS `coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `coupons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `type` enum('percentage','fixed') NOT NULL DEFAULT 'percentage',
  `value` decimal(10,2) NOT NULL,
  `min_order` decimal(10,2) NOT NULL DEFAULT 0.00,
  `max_discount` decimal(10,2) DEFAULT NULL,
  `usage_limit` int(11) DEFAULT NULL,
  `used_count` int(11) NOT NULL DEFAULT 0,
  `expires_at` timestamp NULL DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `coupons_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `coupons`
--

LOCK TABLES `coupons` WRITE;
/*!40000 ALTER TABLE `coupons` DISABLE KEYS */;
INSERT INTO `coupons` VALUES (1,'WELCOME10','percentage',10.00,50.00,50.00,1000,0,'2027-02-20 09:14:30',1,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(2,'SAVE20','percentage',20.00,100.00,100.00,500,0,'2026-08-20 09:14:30',1,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(3,'FLAT15','fixed',15.00,75.00,NULL,NULL,0,'2026-05-20 09:14:30',1,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(4,'TECH30','percentage',30.00,500.00,200.00,200,0,'2026-04-20 09:14:30',1,'2026-02-20 09:14:30','2026-02-20 09:14:30');
/*!40000 ALTER TABLE `coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) NOT NULL,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_10_12_000000_create_users_table',1),(2,'2014_10_12_100000_create_password_resets_table',1),(3,'2019_08_19_000000_create_failed_jobs_table',1),(4,'2019_12_14_000001_create_personal_access_tokens_table',1),(5,'2023_01_01_000001_create_categories_table',1),(6,'2023_01_01_000002_create_vendors_table',1),(7,'2023_01_01_000003_create_products_table',1),(8,'2023_01_01_000004_create_product_images_table',1),(9,'2023_01_01_000005_create_carts_table',1),(10,'2023_01_01_000006_create_wishlists_table',1),(11,'2023_01_01_000007_create_compare_items_table',1),(12,'2023_01_01_000008_create_orders_table',1),(13,'2023_01_01_000009_create_reviews_table',1),(14,'2023_01_01_000010_create_sliders_table',1),(15,'2023_01_01_000011_create_settings_table',1),(16,'2023_01_01_000012_create_newsletters_table',1),(17,'2023_01_01_000013_create_contacts_table',1),(18,'2023_01_01_000014_create_wholesale_applications_table',1),(19,'2023_01_01_000015_create_coupons_table',1),(20,'2023_01_01_000016_update_users_table',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `newsletters`
--

DROP TABLE IF EXISTS `newsletters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `newsletters` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(255) NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `newsletters_email_unique` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `newsletters`
--

LOCK TABLES `newsletters` WRITE;
/*!40000 ALTER TABLE `newsletters` DISABLE KEYS */;
/*!40000 ALTER TABLE `newsletters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_items`
--

DROP TABLE IF EXISTS `order_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `order_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned DEFAULT NULL,
  `product_name` varchar(255) NOT NULL,
  `product_image` varchar(255) DEFAULT NULL,
  `price` decimal(12,2) NOT NULL,
  `sale_price` decimal(12,2) DEFAULT NULL,
  `quantity` int(11) NOT NULL,
  `subtotal` decimal(12,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_items_order_id_foreign` (`order_id`),
  KEY `order_items_product_id_foreign` (`product_id`),
  CONSTRAINT `order_items_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE,
  CONSTRAINT `order_items_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_items`
--

LOCK TABLES `order_items` WRITE;
/*!40000 ALTER TABLE `order_items` DISABLE KEYS */;
INSERT INTO `order_items` VALUES (1,1,10,'Adidas Ultraboost 23 Running Shoes','https://placehold.co/600x600/eeeeee/666666?text=Adidas+Ultraboost+23+Running+Shoes',190.00,149.00,1,149.00,'2026-02-20 11:04:05','2026-02-20 11:04:05'),(2,2,5,'PlayStation 5 Console','https://placehold.co/600x600/eeeeee/666666?text=PlayStation+5+Console',499.00,NULL,2,998.00,'2026-02-20 11:04:05','2026-02-20 11:04:05'),(3,3,9,'Nike Air Max 270 Sneakers','https://placehold.co/600x600/eeeeee/666666?text=Nike+Air+Max+270+Sneakers',150.00,119.00,2,238.00,'2026-02-20 11:04:05','2026-02-20 11:04:05'),(4,4,4,'Sony WH-1000XM5 Noise Cancelling Headphones','https://placehold.co/600x600/eeeeee/666666?text=Sony+WH-1000XM5+Noise+Cancelling+Headphones',399.00,299.00,3,897.00,'2026-02-20 11:04:05','2026-02-20 11:04:05'),(5,5,1,'Apple iPhone 15 Pro Max 256GB','https://placehold.co/600x600/eeeeee/666666?text=Apple+iPhone+15+Pro+Max+256GB',1199.00,1099.00,3,3297.00,'2026-02-20 11:04:05','2026-02-20 11:04:05'),(6,6,5,'PlayStation 5 Console','https://placehold.co/600x600/eeeeee/666666?text=PlayStation+5+Console',499.00,NULL,3,1497.00,'2026-02-20 11:04:05','2026-02-20 11:04:05'),(7,7,2,'MacBook Pro 14\" M3 Pro','https://placehold.co/600x600/eeeeee/666666?text=MacBook+Pro+14%22+M3+Pro',1999.00,1849.00,2,3698.00,'2026-02-20 11:04:05','2026-02-20 11:04:05'),(8,8,6,'LG 55\" 4K OLED Smart TV','https://placehold.co/600x600/eeeeee/666666?text=LG+55%22+4K+OLED+Smart+TV',1499.00,1199.00,1,1199.00,'2026-02-20 11:04:05','2026-02-20 11:04:05'),(9,9,9,'Nike Air Max 270 Sneakers','https://placehold.co/600x600/eeeeee/666666?text=Nike+Air+Max+270+Sneakers',150.00,119.00,3,357.00,'2026-02-20 11:04:05','2026-02-20 11:04:05'),(10,10,8,'Canon EOS R6 Mark II Mirrorless Camera','https://placehold.co/600x600/eeeeee/666666?text=Canon+EOS+R6+Mark+II+Mirrorless+Camera',2499.00,2199.00,3,6597.00,'2026-02-20 11:04:05','2026-02-20 11:04:05'),(11,11,1,'Apple iPhone 15 Pro Max 256GB','https://placehold.co/600x600/eeeeee/666666?text=Apple+iPhone+15+Pro+Max+256GB',1199.00,1099.00,1,1099.00,'2026-02-20 11:06:00','2026-02-20 11:06:00');
/*!40000 ALTER TABLE `order_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `order_number` varchar(255) NOT NULL,
  `status` enum('pending','processing','shipped','delivered','cancelled','refunded') NOT NULL DEFAULT 'pending',
  `subtotal` decimal(12,2) NOT NULL DEFAULT 0.00,
  `discount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `shipping` decimal(12,2) NOT NULL DEFAULT 0.00,
  `tax` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total` decimal(12,2) NOT NULL DEFAULT 0.00,
  `coupon_code` varchar(255) DEFAULT NULL,
  `payment_method` varchar(255) NOT NULL DEFAULT 'cod',
  `payment_status` enum('pending','paid','failed','refunded') NOT NULL DEFAULT 'pending',
  `payment_reference` varchar(255) DEFAULT NULL,
  `shipping_name` varchar(255) DEFAULT NULL,
  `shipping_email` varchar(255) DEFAULT NULL,
  `shipping_phone` varchar(255) DEFAULT NULL,
  `shipping_address` varchar(255) DEFAULT NULL,
  `shipping_city` varchar(255) DEFAULT NULL,
  `shipping_state` varchar(255) DEFAULT NULL,
  `shipping_zip` varchar(255) DEFAULT NULL,
  `shipping_country` varchar(255) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `is_wholesale` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `orders_order_number_unique` (`order_number`),
  KEY `orders_user_id_foreign` (`user_id`),
  CONSTRAINT `orders_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
INSERT INTO `orders` VALUES (1,3,'ORD-77GIZU6SQQ','delivered',149.00,0.00,0.00,11.92,160.92,NULL,'cod','paid',NULL,'Demo Customer','customer@kalses.com','+1-555-0100','123 Main Street','New York','NY','10001','US',NULL,0,'2026-02-19 11:04:05','2026-02-19 11:04:05'),(2,3,'ORD-DHWLIZNJAT','delivered',998.00,0.00,0.00,79.84,1077.84,NULL,'cod','paid',NULL,'Demo Customer','customer@kalses.com','+1-555-0100','123 Main Street','New York','NY','10001','US',NULL,0,'2026-02-18 11:04:05','2026-02-18 11:04:05'),(3,3,'ORD-CQQEJF81YZ','shipped',238.00,0.00,0.00,19.04,257.04,NULL,'cod','paid',NULL,'Demo Customer','customer@kalses.com','+1-555-0100','123 Main Street','New York','NY','10001','US',NULL,0,'2026-02-17 11:04:05','2026-02-17 11:04:05'),(4,3,'ORD-DT3GZTNCNH','processing',897.00,0.00,0.00,71.76,968.76,NULL,'cod','paid',NULL,'Demo Customer','customer@kalses.com','+1-555-0100','123 Main Street','New York','NY','10001','US',NULL,0,'2026-02-16 11:04:05','2026-02-16 11:04:05'),(5,3,'ORD-E8X3ZGCLJ1','delivered',3297.00,0.00,0.00,263.76,3560.76,NULL,'cod','paid',NULL,'Demo Customer','customer@kalses.com','+1-555-0100','123 Main Street','New York','NY','10001','US',NULL,0,'2026-02-15 11:04:05','2026-02-15 11:04:05'),(6,3,'ORD-TO3JVIQZ4H','delivered',1497.00,0.00,0.00,119.76,1616.76,NULL,'cod','paid',NULL,'Demo Customer','customer@kalses.com','+1-555-0100','123 Main Street','New York','NY','10001','US',NULL,0,'2026-02-15 11:04:05','2026-02-15 11:04:05'),(7,3,'ORD-FYKCPYUEXA','pending',3698.00,0.00,0.00,295.84,3993.84,NULL,'cod','pending',NULL,'Demo Customer','customer@kalses.com','+1-555-0100','123 Main Street','New York','NY','10001','US',NULL,0,'2026-02-14 11:04:05','2026-02-14 11:04:05'),(8,3,'ORD-6UIMNEQKD6','delivered',1199.00,0.00,0.00,95.92,1294.92,NULL,'cod','paid',NULL,'Demo Customer','customer@kalses.com','+1-555-0100','123 Main Street','New York','NY','10001','US',NULL,0,'2026-02-13 11:04:05','2026-02-13 11:04:05'),(9,3,'ORD-SOR2CUOS6L','cancelled',357.00,0.00,0.00,28.56,385.56,NULL,'cod','failed',NULL,'Demo Customer','customer@kalses.com','+1-555-0100','123 Main Street','New York','NY','10001','US',NULL,0,'2026-02-12 11:04:05','2026-02-12 11:04:05'),(10,3,'ORD-KTFVULGBU2','delivered',6597.00,0.00,0.00,527.76,7124.76,NULL,'cod','paid',NULL,'Demo Customer','customer@kalses.com','+1-555-0100','123 Main Street','New York','NY','10001','US',NULL,0,'2026-02-10 11:04:05','2026-02-10 11:04:05'),(11,3,'ORD-DYW9V3R41L','pending',1099.00,0.00,0.00,87.92,1186.92,NULL,'cod','pending',NULL,'Demo Customer','customer@kalses.com','+1-555-0100','123 Main Street','New York','NY','10001','US','Test order',0,'2026-02-20 11:06:00','2026-02-20 11:06:00');
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_resets`
--

DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_resets`
--

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) NOT NULL,
  `tokenable_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `token` varchar(64) NOT NULL,
  `abilities` text DEFAULT NULL,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
INSERT INTO `personal_access_tokens` VALUES (1,'App\\Models\\User',1,'api','907133ea9fa4f517598326ef2b978cd835676c3f5209a0b1e9daf13beaf563d9','[\"*\"]','2026-02-20 09:15:24',NULL,'2026-02-20 09:15:03','2026-02-20 09:15:24'),(2,'App\\Models\\User',2,'api','789d2b966ab81bef760bf3ca18b51455425796e0ee8b943e45322c01139522c5','[\"*\"]','2026-02-20 14:24:39',NULL,'2026-02-20 10:50:51','2026-02-20 14:24:39'),(3,'App\\Models\\User',2,'api','e51ae29ead8832076ab1cc933461456ea3860c039ff677fd84284d3868df1757','[\"*\"]',NULL,NULL,'2026-02-20 10:58:58','2026-02-20 10:58:58'),(4,'App\\Models\\User',2,'api','a27eeebe8e1753ebb17ed769b984d25c8ad73571447fd0a3e3796ffe216b4a4f','[\"*\"]','2026-02-20 11:00:00',NULL,'2026-02-20 10:59:59','2026-02-20 11:00:00'),(5,'App\\Models\\User',2,'api','03150d4eb756c37b64a537f1bb839355a33cb26bbf994abad5a5e0560baa8dd7','[\"*\"]','2026-02-20 11:04:25',NULL,'2026-02-20 11:04:25','2026-02-20 11:04:25'),(7,'App\\Models\\User',2,'api','fbe4f08ad7b0caa7668302e47f8861c9862e17c218a433a86465d3a89b320c73','[\"*\"]',NULL,NULL,'2026-02-20 11:33:57','2026-02-20 11:33:57'),(8,'App\\Models\\User',2,'api','21b968c35520ae7bf7dc403134fdfcecdf68fe44bcbdb7627aca71185bc22d73','[\"*\"]',NULL,NULL,'2026-02-20 11:34:16','2026-02-20 11:34:16'),(9,'App\\Models\\User',2,'api','d4a929f730d4b5b7dd1764eafc1e55072f3768bb71e747fcd083d09bdefc2dcd','[\"*\"]','2026-02-20 11:34:31',NULL,'2026-02-20 11:34:30','2026-02-20 11:34:31');
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_images`
--

DROP TABLE IF EXISTS `product_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_images` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) unsigned NOT NULL,
  `url` varchar(255) NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT 0,
  `sort_order` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_images_product_id_foreign` (`product_id`),
  CONSTRAINT `product_images_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_images`
--

LOCK TABLES `product_images` WRITE;
/*!40000 ALTER TABLE `product_images` DISABLE KEYS */;
INSERT INTO `product_images` VALUES (1,1,'https://placehold.co/600x600/eeeeee/666666?text=Apple+iPhone+15+Pro+Max+256GB',1,0,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(2,1,'https://placehold.co/600x600/dddddd/888888?text=View+1',0,1,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(3,1,'https://placehold.co/600x600/dddddd/888888?text=View+2',0,2,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(4,2,'https://placehold.co/600x600/eeeeee/666666?text=MacBook+Pro+14%22+M3+Pro',1,0,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(5,2,'https://placehold.co/600x600/dddddd/888888?text=View+1',0,1,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(6,2,'https://placehold.co/600x600/dddddd/888888?text=View+2',0,2,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(7,3,'https://placehold.co/600x600/eeeeee/666666?text=Samsung+Galaxy+S24+Ultra+256GB',1,0,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(8,3,'https://placehold.co/600x600/dddddd/888888?text=View+1',0,1,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(9,3,'https://placehold.co/600x600/dddddd/888888?text=View+2',0,2,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(10,4,'https://placehold.co/600x600/eeeeee/666666?text=Sony+WH-1000XM5+Noise+Cancelling+Headphones',1,0,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(11,4,'https://placehold.co/600x600/dddddd/888888?text=View+1',0,1,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(12,4,'https://placehold.co/600x600/dddddd/888888?text=View+2',0,2,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(13,5,'https://placehold.co/600x600/eeeeee/666666?text=PlayStation+5+Console',1,0,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(14,5,'https://placehold.co/600x600/dddddd/888888?text=View+1',0,1,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(15,5,'https://placehold.co/600x600/dddddd/888888?text=View+2',0,2,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(16,6,'https://placehold.co/600x600/eeeeee/666666?text=LG+55%22+4K+OLED+Smart+TV',1,0,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(17,6,'https://placehold.co/600x600/dddddd/888888?text=View+1',0,1,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(18,6,'https://placehold.co/600x600/dddddd/888888?text=View+2',0,2,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(19,7,'https://placehold.co/600x600/eeeeee/666666?text=Dell+XPS+15+Laptop+i9',1,0,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(20,7,'https://placehold.co/600x600/dddddd/888888?text=View+1',0,1,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(21,7,'https://placehold.co/600x600/dddddd/888888?text=View+2',0,2,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(22,8,'https://placehold.co/600x600/eeeeee/666666?text=Canon+EOS+R6+Mark+II+Mirrorless+Camera',1,0,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(23,8,'https://placehold.co/600x600/dddddd/888888?text=View+1',0,1,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(24,8,'https://placehold.co/600x600/dddddd/888888?text=View+2',0,2,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(25,9,'https://placehold.co/600x600/eeeeee/666666?text=Nike+Air+Max+270+Sneakers',1,0,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(26,9,'https://placehold.co/600x600/dddddd/888888?text=View+1',0,1,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(27,9,'https://placehold.co/600x600/dddddd/888888?text=View+2',0,2,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(28,10,'https://placehold.co/600x600/eeeeee/666666?text=Adidas+Ultraboost+23+Running+Shoes',1,0,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(29,10,'https://placehold.co/600x600/dddddd/888888?text=View+1',0,1,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(30,10,'https://placehold.co/600x600/dddddd/888888?text=View+2',0,2,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(31,11,'https://placehold.co/600x600/eeeeee/666666?text=Hydro+Flask+32oz+Wide+Mouth+Water+Bottle',1,0,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(32,11,'https://placehold.co/600x600/dddddd/888888?text=View+1',0,1,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(33,11,'https://placehold.co/600x600/dddddd/888888?text=View+2',0,2,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(34,12,'https://placehold.co/600x600/eeeeee/666666?text=Dyson+V15+Detect+Vacuum+Cleaner',1,0,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(35,12,'https://placehold.co/600x600/dddddd/888888?text=View+1',0,1,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(36,12,'https://placehold.co/600x600/dddddd/888888?text=View+2',0,2,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(37,13,'https://placehold.co/600x600/eeeeee/666666?text=IKEA+KALLAX+Shelf+Unit+4x2',1,0,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(38,13,'https://placehold.co/600x600/dddddd/888888?text=View+1',0,1,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(39,13,'https://placehold.co/600x600/dddddd/888888?text=View+2',0,2,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(40,14,'https://placehold.co/600x600/eeeeee/666666?text=Kindle+Paperwhite+16GB+E-Reader',1,0,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(41,14,'https://placehold.co/600x600/dddddd/888888?text=View+1',0,1,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(42,14,'https://placehold.co/600x600/dddddd/888888?text=View+2',0,2,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(43,15,'https://placehold.co/600x600/eeeeee/666666?text=Google+Nest+Hub+2nd+Gen+Smart+Display',1,0,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(44,15,'https://placehold.co/600x600/dddddd/888888?text=View+1',0,1,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(45,15,'https://placehold.co/600x600/dddddd/888888?text=View+2',0,2,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(46,16,'https://placehold.co/600x600/eeeeee/666666?text=Instant+Pot+Duo+7-in-1+Electric+Pressure+Cooker',1,0,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(47,16,'https://placehold.co/600x600/dddddd/888888?text=View+1',0,1,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(48,16,'https://placehold.co/600x600/dddddd/888888?text=View+2',0,2,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(49,17,'https://placehold.co/600x600/eeeeee/666666?text=LEGO+Technic+Bugatti+Bolide+42151',1,0,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(50,17,'https://placehold.co/600x600/dddddd/888888?text=View+1',0,1,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(51,17,'https://placehold.co/600x600/dddddd/888888?text=View+2',0,2,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(52,18,'https://placehold.co/600x600/eeeeee/666666?text=iPad+Pro+12.9%22+M2+Chip+256GB+Wi-Fi',1,0,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(53,18,'https://placehold.co/600x600/dddddd/888888?text=View+1',0,1,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(54,18,'https://placehold.co/600x600/dddddd/888888?text=View+2',0,2,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(55,19,'https://placehold.co/600x600/eeeeee/666666?text=JBL+Charge+5+Portable+Bluetooth+Speaker',1,0,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(56,19,'https://placehold.co/600x600/dddddd/888888?text=View+1',0,1,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(57,19,'https://placehold.co/600x600/dddddd/888888?text=View+2',0,2,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(58,20,'https://placehold.co/600x600/eeeeee/666666?text=Yoga+Mat+Non-Slip+6mm+Thick',1,0,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(59,20,'https://placehold.co/600x600/dddddd/888888?text=View+1',0,1,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(60,20,'https://placehold.co/600x600/dddddd/888888?text=View+2',0,2,'2026-02-20 09:14:30','2026-02-20 09:14:30'),(61,21,'http://localhost/kalsesv2/backend/public/storage/uploads/products/72257dac-897d-406a-bb4d-686cb665e5ba.jpg',1,0,'2026-02-20 11:56:14','2026-02-20 11:56:14'),(62,21,'http://localhost/kalsesv2/backend/public/storage/uploads/products/86d52826-9a05-4dac-b1d9-d333bc4f998e.jpg',0,1,'2026-02-20 11:56:14','2026-02-20 11:56:14'),(63,21,'http://localhost/kalsesv2/backend/public/storage/uploads/products/fdf647c7-9881-4fd9-8469-87b821581468.jpg',0,2,'2026-02-20 11:56:14','2026-02-20 11:56:14');
/*!40000 ALTER TABLE `product_images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` bigint(20) unsigned DEFAULT NULL,
  `vendor_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `short_description` text DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `price` decimal(12,2) NOT NULL DEFAULT 0.00,
  `sale_price` decimal(12,2) DEFAULT NULL,
  `stock` int(11) NOT NULL DEFAULT 0,
  `sku` varchar(255) DEFAULT NULL,
  `brand` varchar(255) DEFAULT NULL,
  `weight` varchar(255) DEFAULT NULL,
  `attributes` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`attributes`)),
  `rating` decimal(3,2) NOT NULL DEFAULT 0.00,
  `reviews_count` int(11) NOT NULL DEFAULT 0,
  `sales_count` int(11) NOT NULL DEFAULT 0,
  `is_featured` tinyint(1) NOT NULL DEFAULT 0,
  `is_deal` tinyint(1) NOT NULL DEFAULT 0,
  `is_new` tinyint(1) NOT NULL DEFAULT 1,
  `is_best_seller` tinyint(1) NOT NULL DEFAULT 0,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `deal_ends_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `products_slug_unique` (`slug`),
  KEY `products_category_id_foreign` (`category_id`),
  KEY `products_vendor_id_foreign` (`vendor_id`),
  CONSTRAINT `products_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE SET NULL,
  CONSTRAINT `products_vendor_id_foreign` FOREIGN KEY (`vendor_id`) REFERENCES `vendors` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,1,1,'Apple iPhone 15 Pro Max 256GB','apple-iphone-15-pro-max-256gb','The most powerful iPhone ever with A17 Pro chip and titanium design.','<p>The iPhone 15 Pro Max features the groundbreaking A17 Pro chip, a titanium design, and an advanced camera system with 5x optical zoom.</p><ul><li>A17 Pro chip</li><li>Titanium frame</li><li>48MP main camera</li><li>5x optical zoom</li></ul>',1199.00,1099.00,44,'APPL-IP15PM-256','Apple',NULL,'{\"Storage\":\"256GB\",\"Color\":\"Natural Titanium\",\"Display\":\"6.7\\\" Super Retina XDR\"}',4.90,156,485,1,1,1,1,1,'2026-02-25 09:14:29','2026-02-20 09:14:30','2026-02-20 11:06:00',NULL),(2,2,1,'MacBook Pro 14\" M3 Pro','macbook-pro-14-m3-pro','M3 Pro chip. Mind-blowing performance for professionals.','<p>MacBook Pro with M3 Pro chip delivers extraordinary performance with up to 18-hour battery life and the stunning Liquid Retina XDR display.</p>',1999.00,1849.00,20,'APPL-MBP14-M3','Apple',NULL,'{\"Chip\":\"M3 Pro\",\"RAM\":\"18GB\",\"Storage\":\"512GB SSD\",\"Display\":\"14.2\\\" Liquid Retina XDR\"}',4.80,89,258,1,0,1,1,1,NULL,'2026-02-20 09:14:30','2026-02-20 09:14:30',NULL),(3,1,5,'Samsung Galaxy S24 Ultra 256GB','samsung-galaxy-s24-ultra-256gb','Galaxy AI. The ultimate Galaxy experience with built-in S Pen.','<p>Samsung Galaxy S24 Ultra with Galaxy AI transforms your smartphone. Features built-in S Pen, 200MP camera, and Snapdragon 8 Gen 3.</p>',1299.00,1149.00,35,'SAMS-S24U-256','Samsung',NULL,'{\"Storage\":\"256GB\",\"RAM\":\"12GB\",\"Camera\":\"200MP\",\"Display\":\"6.8\\\" QHD+\"}',4.70,203,43,1,1,1,0,1,'2026-03-01 09:14:30','2026-02-20 09:14:30','2026-02-20 09:14:30',NULL),(4,NULL,5,'Sony WH-1000XM5 Noise Cancelling Headphones','sony-wh-1000xm5-noise-cancelling-headphones','Industry-leading noise cancellation with 30-hour battery life.','<p>Experience unrivaled noise cancellation with Sony WH-1000XM5. Eight microphones, two processors, 30-hour battery with Quick Charge.</p>',399.00,299.00,60,'SONY-WH1000XM5','Sony',NULL,'{\"Driver\":\"30mm\",\"Battery\":\"30 hours\",\"Connectivity\":\"Bluetooth 5.2\"}',4.90,445,409,1,1,1,1,1,'2026-03-01 09:14:30','2026-02-20 09:14:30','2026-02-20 09:14:30',NULL),(5,7,1,'PlayStation 5 Console','playstation-5-console','Next-gen gaming with ultra-high speed SSD and DualSense controller.','<p>PlayStation 5 offers incredible loading times, deeper immersion through haptic feedback, adaptive triggers, and 3D Audio.</p>',499.00,NULL,15,'SONY-PS5','Sony',NULL,'{\"CPU\":\"AMD Zen 2\",\"GPU\":\"AMD RDNA 2\",\"Storage\":\"825GB SSD\",\"Resolution\":\"4K 120fps\"}',4.90,867,62,1,0,1,1,1,NULL,'2026-02-20 09:14:30','2026-02-20 09:14:30',NULL),(6,6,5,'LG 55\" 4K OLED Smart TV','lg-55-4k-oled-smart-tv','Perfect blacks and infinite contrast with OLED technology.','<p>LG OLED TV with α9 AI Processor 4K Gen6. Self-lit pixels deliver perfect blacks and rich, vibrant colors.</p>',1499.00,1199.00,12,'LG-55-OLED','LG',NULL,'{\"Size\":\"55 inches\",\"Resolution\":\"4K 3840x2160\",\"HDR\":\"Dolby Vision\",\"Smart TV\":\"webOS 23\"}',4.70,123,306,1,1,1,0,1,'2026-02-23 09:14:30','2026-02-20 09:14:30','2026-02-20 09:14:30',NULL),(7,2,5,'Dell XPS 15 Laptop i9','dell-xps-15-laptop-i9','The world\'s most popular 15\" high-performance laptop.','<p>Dell XPS 15 with Intel Core i9 processor and NVIDIA GeForce RTX 4070 GPU delivers exceptional performance for creative professionals.</p>',2299.00,1999.00,8,'DELL-XPS15-I9','Dell',NULL,'{\"CPU\":\"Intel Core i9-13900H\",\"RAM\":\"32GB DDR5\",\"Storage\":\"1TB NVMe SSD\",\"GPU\":\"NVIDIA RTX 4070\"}',4.60,67,412,0,1,1,0,1,'2026-02-24 09:14:30','2026-02-20 09:14:30','2026-02-20 09:14:30',NULL),(8,5,1,'Canon EOS R6 Mark II Mirrorless Camera','canon-eos-r6-mark-ii-mirrorless-camera','A powerhouse hybrid mirrorless for stills and video.','<p>Canon EOS R6 Mark II features a 40MP full-frame sensor with 6K RAW video capabilities and advanced AF with subject detection.</p>',2499.00,2199.00,10,'CANON-EOSR6M2','Canon',NULL,'{\"Sensor\":\"40.2MP Full Frame\",\"Video\":\"6K RAW\",\"Burst\":\"40fps\"}',4.80,45,318,1,0,1,0,1,NULL,'2026-02-20 09:14:30','2026-02-20 09:14:30',NULL),(9,10,2,'Nike Air Max 270 Sneakers','nike-air-max-270-sneakers','The first lifestyle Air Max shoe with a heel unit for all-day comfort.','<p>Nike Air Max 270 features the biggest heel Air unit yet for a super-soft ride that lets you take on the city in style and comfort.</p>',150.00,119.00,100,'NIKE-AM270','Nike',NULL,'{\"Material\":\"Mesh\",\"Sole\":\"Rubber\",\"Closure\":\"Lace-up\"}',4.50,289,225,0,0,1,1,1,NULL,'2026-02-20 09:14:30','2026-02-20 09:14:30',NULL),(10,10,2,'Adidas Ultraboost 23 Running Shoes','adidas-ultraboost-23-running-shoes','Energy return like never before with Boost midsole.','<p>Adidas Ultraboost 23 delivers incredible energy return with Boost technology and a Primeknit+ upper for a snug, adaptive fit.</p>',190.00,149.00,75,'ADID-UB23','Adidas',NULL,'{\"Upper\":\"Primeknit+\",\"Midsole\":\"Boost\",\"Outsole\":\"Continental Rubber\"}',4.70,178,343,1,1,1,0,1,'2026-03-04 09:14:30','2026-02-20 09:14:30','2026-02-20 09:14:30',NULL),(11,11,4,'Hydro Flask 32oz Wide Mouth Water Bottle','hydro-flask-32oz-wide-mouth-water-bottle','Keeps drinks cold 24 hours or hot 12 hours.','<p>Hydro Flask 32oz Wide Mouth is made from professional-grade 18/8 stainless steel with TempShield double-wall vacuum insulation.</p>',49.95,NULL,200,'HF-32WM','Hydro Flask',NULL,'{\"Capacity\":\"32 oz\",\"Material\":\"18\\/8 Stainless Steel\",\"Waterproof\":\"Yes\"}',4.80,512,261,0,0,1,1,1,NULL,'2026-02-20 09:14:30','2026-02-20 09:14:30',NULL),(12,14,2,'Dyson V15 Detect Vacuum Cleaner','dyson-v15-detect-vacuum-cleaner','Laser reveals microscopic dust you\'d otherwise miss.','<p>Dyson V15 Detect features a laser that illuminates microscopic dust and an LCD screen showing what your vacuum has picked up.</p>',749.00,649.00,25,'DYSON-V15','Dyson',NULL,'{\"Suction\":\"230AW\",\"Battery\":\"60 min\",\"Filtration\":\"HEPA\"}',4.70,134,298,1,0,1,0,1,NULL,'2026-02-20 09:14:30','2026-02-20 09:14:30',NULL),(13,15,3,'IKEA KALLAX Shelf Unit 4x2','ikea-kallax-shelf-unit-4x2','Perfect for storing and displaying your belongings.','<p>KALLAX shelf unit is a versatile storage solution. Use it as a room divider or mount on the wall. Compatible with KALLAX inserts.</p>',129.00,NULL,40,'IKEA-KALLAX-4X2','IKEA',NULL,'{\"Dimensions\":\"147x147 cm\",\"Material\":\"Particleboard\",\"Compartments\":\"8\"}',4.30,567,484,0,0,1,1,1,NULL,'2026-02-20 09:14:30','2026-02-20 09:14:30',NULL),(14,NULL,3,'Kindle Paperwhite 16GB E-Reader','kindle-paperwhite-16gb-e-reader','6.8\" display with adjustable warm light and waterproof design.','<p>Kindle Paperwhite features a 6.8\" 300 ppi glare-free display, adjustable warm light, and 10-week battery life. IPX8 waterproof.</p>',139.99,119.99,80,'AMZN-KPW5','Amazon',NULL,'{\"Display\":\"6.8\\\" 300 ppi\",\"Storage\":\"16GB\",\"Battery\":\"10 weeks\",\"Waterproof\":\"IPX8\"}',4.60,892,144,0,1,1,0,1,'2026-02-28 09:14:30','2026-02-20 09:14:30','2026-02-20 09:14:30',NULL),(15,1,5,'Google Nest Hub 2nd Gen Smart Display','google-nest-hub-2nd-gen-smart-display','Smart home hub with sleep tracking and Google Assistant.','<p>Google Nest Hub 2nd Gen features a 7\" display, sleep sensing, and Google Assistant to help manage your smart home hands-free.</p>',99.99,79.99,55,'GOOG-NH2','Google',NULL,'{\"Display\":\"7\\\" LCD\",\"Connectivity\":\"Wi-Fi, Bluetooth\",\"Color\":\"Chalk\"}',4.40,234,194,0,1,1,0,1,'2026-03-03 09:14:30','2026-02-20 09:14:30','2026-02-20 09:14:30',NULL),(16,8,3,'Instant Pot Duo 7-in-1 Electric Pressure Cooker','instant-pot-duo-7-in-1-electric-pressure-cooker','7-in-1 multi-use: pressure cooker, slow cooker, rice cooker and more.','<p>Instant Pot Duo 7-in-1 replaces 7 kitchen appliances. Cooks up to 70% faster than traditional methods.</p>',99.95,79.95,90,'IP-DUO-7QT','Instant Pot',NULL,'{\"Capacity\":\"7 Quart\",\"Functions\":\"7-in-1\",\"Programs\":\"13 built-in\"}',4.70,1245,459,0,0,1,1,1,NULL,'2026-02-20 09:14:30','2026-02-20 09:14:30',NULL),(17,13,3,'LEGO Technic Bugatti Bolide 42151','lego-technic-bugatti-bolide-42151','905-piece Bugatti Bolide model for ages 10+.','<p>Build the iconic Bugatti Bolide with 905 LEGO Technic pieces. Features W16 engine with moving pistons, steerable front wheels.</p>',59.99,NULL,35,'LEGO-42151','LEGO',NULL,'{\"Pieces\":\"905\",\"Age\":\"10+\",\"Theme\":\"Technic\"}',4.80,189,76,0,0,1,0,1,NULL,'2026-02-20 09:14:30','2026-02-20 09:14:30',NULL),(18,3,1,'iPad Pro 12.9\" M2 Chip 256GB Wi-Fi','ipad-pro-129-m2-chip-256gb-wi-fi','Supercharged by M2. The ultimate iPad experience.','<p>iPad Pro with M2 chip features a stunning Liquid Retina XDR display, ProMotion technology up to 120Hz, and USB-C with Thunderbolt.</p>',1099.00,999.00,22,'APPL-IPADPRO-M2','Apple',NULL,'{\"Chip\":\"Apple M2\",\"Display\":\"12.9\\\" Liquid Retina XDR\",\"Storage\":\"256GB\"}',4.90,98,189,1,1,1,0,1,'2026-03-05 09:14:30','2026-02-20 09:14:30','2026-02-20 09:14:30',NULL),(19,NULL,1,'JBL Charge 5 Portable Bluetooth Speaker','jbl-charge-5-portable-bluetooth-speaker','Waterproof Bluetooth speaker with 20-hour battery.','<p>JBL Charge 5 delivers bold JBL Original Pro Sound with powerful bass, IP67 waterproof design, and 20-hour battery life.</p>',179.95,149.95,65,'JBL-CHARGE5','JBL',NULL,'{\"Power\":\"30W\",\"Battery\":\"20 hours\",\"Waterproof\":\"IP67\",\"Connectivity\":\"Bluetooth 5.1\"}',4.60,345,291,0,1,1,1,1,'2026-02-27 09:14:30','2026-02-20 09:14:30','2026-02-20 09:14:30',NULL),(20,11,4,'Yoga Mat Non-Slip 6mm Thick','yoga-mat-non-slip-6mm-thick','Premium non-slip yoga mat with carrying strap.','<p>FitPro yoga mat features superior grip on both sides, eco-friendly TPE material, and 6mm thickness for joint protection.</p>',39.99,29.99,150,'YM-6MM-NBK','FitPro',NULL,'{\"Thickness\":\"6mm\",\"Material\":\"TPE\",\"Dimensions\":\"183x61 cm\"}',4.50,456,307,0,0,1,0,1,NULL,'2026-02-20 09:14:30','2026-02-20 09:14:30',NULL),(21,NULL,1,'abc','abc-nI5cUH',NULL,NULL,10.00,8.00,0,NULL,NULL,NULL,NULL,0.00,0,0,0,0,1,0,1,NULL,'2026-02-20 11:20:49','2026-02-20 11:20:49',NULL);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reviews`
--

DROP TABLE IF EXISTS `reviews`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reviews` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `rating` int(11) NOT NULL DEFAULT 5,
  `title` varchar(255) DEFAULT NULL,
  `body` text NOT NULL,
  `is_approved` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reviews_product_id_foreign` (`product_id`),
  KEY `reviews_user_id_foreign` (`user_id`),
  CONSTRAINT `reviews_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `reviews_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reviews`
--

LOCK TABLES `reviews` WRITE;
/*!40000 ALTER TABLE `reviews` DISABLE KEYS */;
/*!40000 ALTER TABLE `reviews` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `group` varchar(255) NOT NULL DEFAULT 'general',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (1,'site_name','Kalses','general','2026-02-20 09:14:30','2026-02-20 09:14:30'),(2,'site_tagline','Your One-Stop Online Shop','general','2026-02-20 09:14:30','2026-02-20 09:14:30'),(3,'contact_email','info@kalses.com','general','2026-02-20 09:14:30','2026-02-20 09:14:30'),(4,'contact_phone','1900-888','general','2026-02-20 09:14:30','2026-02-20 09:14:30'),(5,'contact_address','123 Main Street, City, Country','general','2026-02-20 09:14:30','2026-02-20 09:14:30'),(6,'currency','USD','general','2026-02-20 09:14:30','2026-02-20 09:14:30'),(7,'currency_symbol','$','general','2026-02-20 09:14:30','2026-02-20 09:14:30'),(8,'tax_rate','8','general','2026-02-20 09:14:30','2026-02-20 09:14:30'),(9,'shipping_free_threshold','100','shipping','2026-02-20 09:14:30','2026-02-20 09:14:30'),(10,'facebook_url','#','social','2026-02-20 09:14:30','2026-02-20 09:14:30'),(11,'instagram_url','#','social','2026-02-20 09:14:30','2026-02-20 09:14:30'),(12,'twitter_url','#','social','2026-02-20 09:14:30','2026-02-20 09:14:30'),(13,'gallery_panels','[{\"image\":\"http:\\/\\/localhost\\/kalsesv2\\/backend\\/public\\/storage\\/uploads\\/products\\/286e4e40-7e77-4e20-941f-0cf118e75726.png\",\"title\":\"Gaming\",\"subtitle\":\"Collection\",\"label\":\"Hot Deal\",\"link\":\"\\/shop\"},{\"image\":\"http:\\/\\/localhost\\/kalsesv2\\/backend\\/public\\/storage\\/uploads\\/products\\/3474a6fd-9f51-4139-9080-d7b847a4410b.png\",\"title\":\"Controllers\",\"subtitle\":\"For all platforms\",\"link\":\"\\/shop\"},{\"image\":\"http:\\/\\/localhost\\/kalsesv2\\/backend\\/public\\/storage\\/uploads\\/products\\/c47efb6f-0d70-447d-8b8a-20b3c8bbe3d1.png\",\"title\":\"VR Headsets\",\"subtitle\":\"Experience the future\",\"link\":\"\\/shop\"},{\"image\":\"http:\\/\\/localhost\\/kalsesv2\\/backend\\/public\\/storage\\/uploads\\/products\\/724d6d1a-6417-4e9c-86bc-ed5e9cffcc94.png\",\"title\":\"Accessories\",\"subtitle\":\"Must-have gadgets\",\"link\":\"\\/shop\"},{\"image\":\"http:\\/\\/localhost\\/kalsesv2\\/backend\\/public\\/storage\\/uploads\\/products\\/bb0f4df6-1f4c-4174-aeca-623c2230a549.png\",\"title\":\"Smartphones\",\"subtitle\":\"Latest models available\",\"link\":\"\\/shop\"}]','general','2026-02-20 13:37:09','2026-02-20 13:37:09'),(14,'trust_badges','[{\"icon\":null,\"title\":\"Free Shipping\",\"desc\":\"On orders over $50\"},{\"icon\":null,\"title\":\"Easy Returns\",\"desc\":\"30-day return policy\"},{\"icon\":null,\"title\":\"Secure Payment\",\"desc\":\"100% secure checkout\"},{\"icon\":null,\"title\":\"24\\/7 Support\",\"desc\":\"Dedicated support team\"}]','general','2026-02-20 13:37:09','2026-02-20 13:37:09'),(15,'testimonials','[{\"avatar\":null,\"name\":\"Sarah Johnson\",\"stars\":5,\"text\":\"Amazing quality products and super fast shipping! Highly recommend!\"},{\"avatar\":null,\"name\":\"Michael Brown\",\"stars\":5,\"text\":\"Great customer service! They resolved my issue within hours.\"},{\"avatar\":null,\"name\":\"Emily Davis\",\"stars\":5,\"text\":\"Best prices online! Found exactly what I needed in minutes.\"}]','general','2026-02-20 13:37:09','2026-02-20 13:37:09'),(16,'brands','[{\"image\":null,\"name\":\"Apple\",\"link\":\"\\/shop?brand=apple\"},{\"image\":null,\"name\":\"Samsung\",\"link\":\"\\/shop?brand=samsung\"},{\"image\":null,\"name\":\"Sony\",\"link\":\"\\/shop?brand=sony\"},{\"image\":null,\"name\":\"Dell\",\"link\":\"\\/shop?brand=dell\"},{\"image\":null,\"name\":\"HP\",\"link\":\"\\/shop?brand=hp\"},{\"image\":null,\"name\":\"Logitech\",\"link\":\"\\/shop?brand=logitech\"}]','general','2026-02-20 13:37:09','2026-02-20 13:37:09');
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sliders`
--

DROP TABLE IF EXISTS `sliders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sliders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `subtitle` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `image` varchar(255) NOT NULL,
  `link` varchar(255) DEFAULT NULL,
  `button_text` varchar(255) DEFAULT NULL,
  `sort_order` int(11) NOT NULL DEFAULT 0,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sliders`
--

LOCK TABLES `sliders` WRITE;
/*!40000 ALTER TABLE `sliders` DISABLE KEYS */;
INSERT INTO `sliders` VALUES (1,'Latest iPhone 15 Pro Max','New Arrival 2024','Experience the future with titanium design and A17 Pro chip. Starting at $1,099','http://localhost/kalsesv2/backend/public/storage/uploads/products/ccb9a025-e6c7-4182-b244-c0fcab2890c6.jpg','/product/apple-iphone-15-pro-max-256gb','Shop Now',1,1,'2026-02-20 09:14:30','2026-02-20 12:04:45'),(2,'Sony WH-1000XM5','Best in Class Noise Cancellation','Industry-leading noise cancellation. Now $299 — Save $100!','http://localhost/kalsesv2/backend/public/storage/uploads/products/e1ce6d04-8ad6-481e-a435-233a92d0ab1c.jpg','/product/sony-wh-1000xm5-noise-cancelling-headphones','Shop Now',2,1,'2026-02-20 09:14:30','2026-02-20 12:31:30'),(3,'MacBook Pro M3 Pro','Pro Performance Unleashed','Mind-blowing performance for creative professionals. From $1,849','http://localhost/kalsesv2/backend/public/storage/uploads/products/8fd87850-6ae2-4e09-9033-38a9729bd0ef.jpg','/product/macbook-pro-14-m3-pro','Explore',3,1,'2026-02-20 09:14:30','2026-02-20 12:31:42');
/*!40000 ALTER TABLE `sliders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `avatar` varchar(255) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `zip` varchar(255) DEFAULT NULL,
  `country` varchar(255) DEFAULT NULL,
  `is_admin` tinyint(1) NOT NULL DEFAULT 0,
  `is_wholesale` tinyint(1) NOT NULL DEFAULT 0,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'Test User','test@kalses.com',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'$2y$10$IOXH2LDfxNLy69DrtotskOWnRpSKCV2bbb.j2P8CUjEUdX8cH9EwO',NULL,'2026-02-20 09:15:03','2026-02-20 09:15:03'),(2,'Administrator','admin@kalses.com',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,'$2y$10$GqFNLVLB3h3SERnHZ4e50eqRIr5dxOonxoGyGHO9q.QHdu16huu6W',NULL,'2026-02-20 09:39:12','2026-02-20 11:04:04'),(3,'Demo Customer','customer@kalses.com','+1-555-0100',NULL,'123 Main Street','New York','NY','10001','US',0,0,NULL,'$2y$10$QQKQ1/2tRxc36oWMV52Zlegro2wQ.hiWlhasCzH.hBoEZqLoEj1WO',NULL,'2026-02-20 11:04:04','2026-02-20 11:30:20');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `vendors`
--

DROP TABLE IF EXISTS `vendors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `vendors` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `store_name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `logo` varchar(255) DEFAULT NULL,
  `banner` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `rating` decimal(3,2) NOT NULL DEFAULT 0.00,
  `reviews_count` int(11) NOT NULL DEFAULT 0,
  `followers_count` int(11) NOT NULL DEFAULT 0,
  `products_count` int(11) NOT NULL DEFAULT 0,
  `is_verified` tinyint(1) NOT NULL DEFAULT 0,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `vendors_slug_unique` (`slug`),
  KEY `vendors_user_id_foreign` (`user_id`),
  CONSTRAINT `vendors_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `vendors`
--

LOCK TABLES `vendors` WRITE;
/*!40000 ALTER TABLE `vendors` DISABLE KEYS */;
INSERT INTO `vendors` VALUES (1,NULL,'TechZone Store','techzone-store','Your premier destination for the latest tech gadgets and electronics.',NULL,NULL,'techzone@example.com','+1-555-0101','123 Tech Ave, Silicon Valley, CA 94025',NULL,4.80,234,1520,48,1,1,'2026-02-20 09:14:29','2026-02-20 09:14:29'),(2,NULL,'FashionHub','fashionhub','Trendy clothing and accessories for the modern lifestyle.',NULL,NULL,'fashionhub@example.com','+1-555-0102','456 Fashion Blvd, New York, NY 10001',NULL,4.60,189,2340,120,1,1,'2026-02-20 09:14:29','2026-02-20 09:14:29'),(3,NULL,'HomeDecor Pro','homedecor-pro','Beautiful furniture and home decor at affordable prices.',NULL,NULL,'homedecor@example.com','+1-555-0103','789 Interior Lane, Chicago, IL 60601',NULL,4.50,156,890,75,1,1,'2026-02-20 09:14:29','2026-02-20 09:14:29'),(4,NULL,'SportsMaster','sportsmaster','Professional sports equipment for every athlete.',NULL,NULL,'sportsmaster@example.com','+1-555-0104','321 Sports Drive, Dallas, TX 75201',NULL,4.70,98,670,62,0,1,'2026-02-20 09:14:29','2026-02-20 09:14:29'),(5,NULL,'GadgetWorld','gadgetworld','Innovative gadgets and smart home devices.',NULL,NULL,'gadgetworld@example.com','+1-555-0105','555 Innovation Park, Seattle, WA 98101',NULL,4.40,213,1100,88,1,1,'2026-02-20 09:14:29','2026-02-20 09:14:29');
/*!40000 ALTER TABLE `vendors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wholesale_applications`
--

DROP TABLE IF EXISTS `wholesale_applications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wholesale_applications` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `business_name` varchar(255) NOT NULL,
  `contact_name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `address` text DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `zip` varchar(255) DEFAULT NULL,
  `country` varchar(255) DEFAULT NULL,
  `business_type` varchar(255) DEFAULT NULL,
  `tax_id` varchar(255) DEFAULT NULL,
  `annual_revenue` varchar(255) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `status` enum('pending','approved','rejected') NOT NULL DEFAULT 'pending',
  `admin_notes` text DEFAULT NULL,
  `discount_rate` decimal(5,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wholesale_applications_user_id_unique` (`user_id`),
  CONSTRAINT `wholesale_applications_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wholesale_applications`
--

LOCK TABLES `wholesale_applications` WRITE;
/*!40000 ALTER TABLE `wholesale_applications` DISABLE KEYS */;
/*!40000 ALTER TABLE `wholesale_applications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wishlist_items`
--

DROP TABLE IF EXISTS `wishlist_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wishlist_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wishlist_items_user_id_product_id_unique` (`user_id`,`product_id`),
  KEY `wishlist_items_product_id_foreign` (`product_id`),
  CONSTRAINT `wishlist_items_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `wishlist_items_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wishlist_items`
--

LOCK TABLES `wishlist_items` WRITE;
/*!40000 ALTER TABLE `wishlist_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `wishlist_items` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2026-02-21  0:12:55
