import { useState } from 'react'
import { Link } from 'react-router-dom'

const sections = [
  {
    id: 'collection',
    heading: '1. Collection of Personal Data',
    subsections: [
      {
        title: '1.1 Definition of personal data',
        content: `Personal data means any information relating to an identified or identifiable natural person ('data subject');
          an identifiable natural person is one who can be identified, directly or indirectly, in particular by reference to an
          identifier such as a name, an identification number, location data, or other factors specific to the physical, physiological,
          genetic, mental, economic, cultural or social identity of that natural person. Personal data does not include data that has
          been irreversibly anonymized or aggregated so that it can no longer enable us, whether in combination with other information
          or otherwise, to identify you.`,
      },
      {
        title: '1.2 What Personal Data We Collect',
        content: `Depending on the products and services you choose, we collect different kinds of personal data from or about you.
          This includes data you provide directly (name, email, shipping address, payment details), data from your device (IP address,
          browser type, device identifiers), data about your purchases and transactions, and data that helps us improve our services
          (usage patterns, diagnostic information, and location data where available).`,
      },
      {
        title: '1.3 What is the Source of Your Personal Data',
        content: `With your express consent, we collect your personal data: (a) from you directly when you create an account, place
          an order, or contact us; (b) from your terminal equipment as described above; (c) from our partners such as Google,
          Facebook, or Twitter when you log in through these accounts; and (d) from cookies and similar technologies when you visit
          our website.`,
      },
    ],
  },
  {
    id: 'cookies',
    heading: '2. How We Use Cookies and Similar Technologies',
    subsections: [
      {
        title: '2.1 Definition of Cookies',
        content: `Cookies are small text files placed on your device by websites you browse. They remember your preferences and
          chosen items, improve your site experience, and help ensure that the offers you see online are relevant to you. In and of
          themselves, cookies are harmless and serve crucial functions for websites.`,
      },
      {
        title: '2.2 Types of Cookies',
        content: `(a) Strictly Necessary Cookies — essential for browsing our website and using fundamental services. These do not
          require your consent. (b) Statistics Cookies — collect anonymous usage information to help us understand how customers use
          our site (e.g., Google Analytics). (c) Preferences Cookies — remember your choices such as language and login credentials
          to improve your experience. (d) Marketing Cookies — track browsing habits to deliver personalized advertisements across
          third-party sites and platforms.`,
      },
      {
        title: '2.3 How to Control Your Cookie Settings',
        content: `When you first visit the website, we will ask for your consent via a cookie banner. You can select the types of
          cookies you accept. You can also remove or reject cookies through your browser or device settings. Please note that
          disabling certain cookies may restrict access to some features of our website.`,
      },
    ],
  },
  {
    id: 'processing',
    heading: '3. How We Process Your Personal Data',
    subsections: [
      {
        title: '3.1 Providing, improving, and developing our products and services',
        content: `We use your personal data to help provide and improve our products and services — including registration, order
          processing, product search, and checkout. This processing is based on your prior express consent or our legitimate interest
          in offering you quality services.`,
      },
      {
        title: '3.2 Communicating with you',
        content: `We use your personal data to communicate about your account, transactions, and our policies. We may also send
          promotional emails and newsletters where you have opted in to receive them.`,
      },
      {
        title: '3.3 Offering and measuring targeted advertisements',
        content: `Subject to your prior consent, we may use your browsing and purchase data to personalize product recommendations
          and promotional offers. We may share encrypted data with trusted third-party advertising partners. You may opt out at any
          time by clicking the unsubscribe link in promotional emails or contacting us directly.`,
      },
      {
        title: '3.4 Promoting safety and security',
        content: `We use technology measures to protect your personal data, verify accounts, monitor for fraud, and investigate
          suspicious activity. This processing is based on our legitimate interest in maintaining the safety and integrity of our
          platform.`,
      },
    ],
  },
  {
    id: 'disclosure',
    heading: '4. Disclosure of Personal Data',
    subsections: [
      {
        title: '4.1 Service Providers',
        content: `We share personal data with companies that provide services on our behalf, such as website hosting, payment
          processing, order fulfillment, customer service, and analytics. These companies are contractually obligated to protect
          your data and use it only for the specified purposes.`,
      },
      {
        title: '4.2 Corporate Affiliates and Business Transactions',
        content: `We may share personal data with affiliated companies and business partners. In the event of a merger,
          reorganization, acquisition, or sale of our business, personal data may be transferred to the relevant parties as part
          of that transaction.`,
      },
      {
        title: '4.3 Legal Compliance and Security',
        content: `We may disclose personal data where required by law, legal process, or government authority. We may also disclose
          data to protect our rights, enforce our terms, investigate fraud, or ensure the safety of our platform and users.`,
      },
    ],
  },
  {
    id: 'storage',
    heading: '5. How We Store Your Personal Data',
    subsections: [
      {
        title: '5.1 Data Retention',
        content: `We take technical measures to ensure your personal data is complete and accurate. Subject to your prior consent,
          we may retain records of your personal data for up to ten years to comply with legal obligations and provide ongoing
          services. You may request deletion of your personal data at any time through your account settings or by contacting us.`,
      },
    ],
  },
  {
    id: 'rights',
    heading: '6. Your Rights',
    subsections: [
      {
        title: '6.1 What are your rights',
        content: `You have the right to: (a) access and receive confirmation of whether your personal data is being processed;
          (b) update or correct inaccurate data; (c) request erasure of your personal data; (d) restrict or object to certain
          processing activities; (e) receive your data in a structured, machine-readable format (data portability); and
          (f) lodge a complaint with a supervisory authority if you believe your rights have not been respected.`,
      },
      {
        title: '6.2 How to exercise your rights',
        content: `You can exercise your rights by: (a) adjusting your cookie preferences in the cookie banner or your browser
          settings; (b) updating your account settings in your Kalses account dashboard; or (c) contacting us directly at
          Info@kalses.com. We will respond to requests within 30 days and take all reasonable steps to fulfill your request
          in accordance with applicable law.`,
      },
      {
        title: '6.3 Influence of some rights settings',
        content: `Deleting certain types of personal data may impact the services we can provide: (a) deleting service-related
          data may reduce our ability to optimize your experience; (b) deleting contact data may prevent us from communicating
          with you about orders or inquiries; (c) opting out of marketing data means you will no longer receive personalized
          offers; (d) deleting security-related data may put your account at increased risk.`,
      },
    ],
  },
  {
    id: 'terms',
    heading: '7. Terms of Service',
    subsections: [
      {
        title: '7.1 Acceptance of Terms',
        content: `By accessing and using the Kalses website and services, you accept and agree to be bound by these Terms and
          Conditions. If you do not agree to these terms, please do not use our services.`,
      },
      {
        title: '7.2 Products and Pricing',
        content: `We reserve the right to modify prices at any time. All prices are displayed in USD unless otherwise stated.
          We do our best to ensure all product descriptions and pricing are accurate, but errors may occur. In the event of a
          pricing error, we reserve the right to cancel orders placed at the incorrect price.`,
      },
      {
        title: '7.3 Orders, Returns and Refunds',
        content: `All orders are subject to acceptance and availability. We offer a 30-day return policy for most products.
          Items must be in original, unused condition with all original packaging. Perishable goods, personalized items, and
          digital products are non-returnable. Refunds are processed within 5-10 business days of receiving the returned item.`,
      },
      {
        title: '7.4 Intellectual Property',
        content: `All content on this website — including text, graphics, logos, images, and software — is the property of
          Kalses LLC or its content suppliers and is protected by copyright law. You may not reproduce, distribute, or create
          derivative works without our express written permission.`,
      },
      {
        title: '7.5 Limitation of Liability',
        content: `Kalses LLC shall not be liable for any indirect, incidental, special, consequential, or punitive damages
          resulting from your use of or inability to use our services. Our total liability shall not exceed the amount paid by
          you for the product or service giving rise to the claim.`,
      },
      {
        title: '7.6 Governing Law',
        content: `These Terms and Conditions shall be governed by and construed in accordance with the laws of the State of
          Missouri, United States. Any disputes arising under these terms shall be submitted to the jurisdiction of the courts
          located in Kansas City, Missouri.`,
      },
      {
        title: '7.7 Changes to Terms',
        content: `We reserve the right to modify these Terms and Conditions at any time. Changes are effective immediately
          upon posting to the website. Your continued use of our services after any changes constitutes your acceptance of the
          updated terms.`,
      },
    ],
  },
]

const navLinks = [
  { id: 'collection', label: 'Data Collection' },
  { id: 'cookies', label: 'Cookies' },
  { id: 'processing', label: 'Data Processing' },
  { id: 'disclosure', label: 'Disclosure' },
  { id: 'storage', label: 'Data Storage' },
  { id: 'rights', label: 'Your Rights' },
  { id: 'terms', label: 'Terms of Service' },
]

const Terms = () => {
  const [activeSection, setActiveSection] = useState('collection')

  const scrollToSection = (id) => {
    setActiveSection(id)
    const el = document.getElementById(`section-${id}`)
    if (el) {
      el.scrollIntoView({ behavior: 'smooth', block: 'start' })
    }
  }

  return (
    <main className="main">
      {/* Breadcrumb */}
      <div className="section-box">
        <div className="breadcrumbs-div">
          <div className="container">
            <ul className="breadcrumb">
              <li><Link className="font-xs color-gray-1000" to="/">Home</Link></li>
              <li><span className="font-xs color-gray-500">Pages</span></li>
              <li><span className="font-xs color-gray-500">Terms &amp; Conditions</span></li>
            </ul>
          </div>
        </div>
      </div>

      <section className="section-box shop-template mt-30">
        <div className="container">
          <div className="row">
            <div className="col-lg-10 mx-auto page-content">

              <h2 className="text-center mb-10">Term and Condition</h2>
              <p className="text-center font-sm color-gray-500 mb-20">
                Last updated: February 20, 2026 &nbsp;|&nbsp; Effective: February 20, 2026
              </p>
              <img
                className="mb-30"
                src="/assets/imgs/page/about/team.jpg"
                alt="Kalses Terms and Conditions"
                style={{ width: '100%', borderRadius: 8, maxHeight: 320, objectFit: 'cover' }}
                onError={e => { e.target.style.display = 'none' }}
              />

              <p className="font-sm color-gray-700 mb-30">
                Thank you for supporting Kalses LLC. In order to protect your personal data when you enjoy using services at Kalses,
                we have drawn up this privacy policy and terms of service. Please read these terms carefully. By using our website
                and services, you agree to the following terms and conditions.
              </p>

              {/* Section Navigation */}
              <div
                className="mb-40"
                style={{
                  background: '#f8f9fa',
                  border: '1px solid #e8e8e8',
                  borderRadius: 10,
                  padding: '20px 24px',
                }}
              >
                <h5 className="mb-15" style={{ fontSize: 14, textTransform: 'uppercase', letterSpacing: 1, color: '#666' }}>
                  Jump to Section
                </h5>
                <div style={{ display: 'flex', flexWrap: 'wrap', gap: 8 }}>
                  {navLinks.map((link) => (
                    <button
                      key={link.id}
                      onClick={() => scrollToSection(link.id)}
                      style={{
                        padding: '6px 16px',
                        borderRadius: 20,
                        border: activeSection === link.id ? '2px solid #3BB77E' : '1px solid #ddd',
                        background: activeSection === link.id ? '#f0fdf4' : '#fff',
                        color: activeSection === link.id ? '#3BB77E' : '#555',
                        fontSize: 13,
                        fontWeight: activeSection === link.id ? 600 : 400,
                        cursor: 'pointer',
                        transition: 'all 0.2s',
                      }}
                    >
                      {link.label}
                    </button>
                  ))}
                </div>
              </div>

              {/* Sections */}
              {sections.map((section) => (
                <div key={section.id} id={`section-${section.id}`} className="mb-40" style={{ scrollMarginTop: 80 }}>
                  <h5
                    style={{
                      paddingBottom: 10,
                      borderBottom: '2px solid #3BB77E',
                      marginBottom: 20,
                      color: '#253D4E',
                    }}
                  >
                    {section.heading}
                  </h5>
                  {section.subsections.map((sub, i) => (
                    <div key={i} className="mb-20">
                      <p className="mb-5">
                        <strong className="color-gray-900">{sub.title}</strong>
                      </p>
                      <p className="font-sm color-gray-700" style={{ lineHeight: 1.8 }}>
                        {sub.content}
                      </p>
                    </div>
                  ))}
                </div>
              ))}

              {/* Contact */}
              <div
                style={{
                  background: '#f0fdf4',
                  border: '1px solid #bbf7d0',
                  borderRadius: 10,
                  padding: '28px 32px',
                  marginTop: 20,
                  marginBottom: 40,
                }}
              >
                <h5 className="mb-10">Questions About These Terms?</h5>
                <p className="font-sm color-gray-700 mb-15">
                  If you have any questions about these Terms and Conditions or our Privacy Policy, please contact us:
                </p>
                <p className="font-sm color-gray-700 mb-5">
                  <strong>Email:</strong>{' '}
                  <a href="mailto:Info@kalses.com" className="color-gray-900">Info@kalses.com</a>
                </p>
                <p className="font-sm color-gray-700 mb-5">
                  <strong>Phone:</strong>{' '}
                  <a href="tel:+19136670804" className="color-gray-900">(913) 667-0804</a>
                </p>
                <p className="font-sm color-gray-700">
                  <strong>Mail:</strong> Kalses LLC, 8301 State Line Rd. Ste 220 #2547, Kansas City, Missouri 64114, USA
                </p>
              </div>

              <h5 className="text-center color-gray-700">Thank you for choosing Kalses.</h5>

            </div>
          </div>
        </div>
      </section>
    </main>
  )
}

export default Terms
