import { useState } from 'react'
import { Link, useNavigate } from 'react-router-dom'

const suggestedLinks = [
  { label: 'Home', to: '/' },
  { label: 'Shop All Products', to: '/shop' },
  { label: 'Baby Products', to: '/shop?category=baby' },
  { label: 'Beauty & Personal Care', to: '/shop?category=beauty' },
  { label: 'Pet Supplies', to: '/shop?category=pets' },
  { label: 'Grocery & Gourmet Food', to: '/shop?category=grocery' },
  { label: 'Contact Us', to: '/contact' },
  { label: 'About Kalses', to: '/about' },
]

const NotFound = () => {
  const [searchQuery, setSearchQuery] = useState('')
  const navigate = useNavigate()

  const handleSearch = (e) => {
    e.preventDefault()
    const q = searchQuery.trim()
    if (q) {
      navigate(`/shop?search=${encodeURIComponent(q)}`)
    }
  }

  return (
    <main className="main">
      <section className="section-box shop-template mt-60">
        <div className="container">

          {/* 404 Hero */}
          <div className="text-center mb-60 mt-50">
            <div className="image-404 mb-30">
              <img
                src="/assets/imgs/page/account/404.png"
                alt="404 - Page Not Found"
                style={{ maxWidth: 320, width: '100%' }}
                onError={e => { e.target.style.display = 'none' }}
              />
            </div>
            <h3 className="mb-10">404 - Page Not Found</h3>
            <p className="font-md-bold color-gray-600 mb-5">
              Looks like, this page doesn't exist
            </p>
            <p className="font-sm color-gray-500 mb-30" style={{ maxWidth: 480, margin: '0 auto 24px' }}>
              The page you're looking for may have been moved, renamed, or removed. Don't worry — there's plenty more to explore.
            </p>
            <div className="mt-15">
              <Link className="btn btn-buy w-auto" to="/">
                Back to Homepage
              </Link>
              <Link
                className="btn btn-border w-auto"
                to="/shop"
                style={{ marginLeft: 12 }}
              >
                Browse Shop
              </Link>
            </div>
          </div>

          {/* Search Box */}
          <div className="row justify-content-center mb-50">
            <div className="col-lg-6 col-md-8">
              <div
                style={{
                  background: '#f8f9fa',
                  border: '1px solid #e8e8e8',
                  borderRadius: 12,
                  padding: '28px 32px',
                  textAlign: 'center',
                }}
              >
                <h5 className="mb-5">Looking for something specific?</h5>
                <p className="font-sm color-gray-500 mb-20">Search our catalog for the product you need.</p>
                <form onSubmit={handleSearch}>
                  <div style={{ display: 'flex', gap: 8 }}>
                    <input
                      className="form-control"
                      type="text"
                      placeholder="Search products..."
                      value={searchQuery}
                      onChange={(e) => setSearchQuery(e.target.value)}
                      style={{ flex: 1 }}
                    />
                    <button
                      type="submit"
                      className="btn btn-buy w-auto"
                      style={{ whiteSpace: 'nowrap', paddingLeft: 20, paddingRight: 20 }}
                    >
                      Search
                    </button>
                  </div>
                </form>
              </div>
            </div>
          </div>

          {/* Suggested Links */}
          <div className="row justify-content-center mb-80">
            <div className="col-lg-8">
              <h5 className="color-gray-500 mb-20 text-center">
                Or explore these popular pages
              </h5>
              <div
                style={{
                  display: 'flex',
                  flexWrap: 'wrap',
                  gap: 10,
                  justifyContent: 'center',
                }}
              >
                {suggestedLinks.map((link) => (
                  <Link
                    key={link.to}
                    to={link.to}
                    style={{
                      display: 'inline-block',
                      padding: '8px 20px',
                      border: '1px solid #e0e0e0',
                      borderRadius: 24,
                      fontSize: 14,
                      color: '#253D4E',
                      background: '#fff',
                      textDecoration: 'none',
                      transition: 'all 0.2s',
                    }}
                    onMouseEnter={e => {
                      e.currentTarget.style.background = '#f0fdf4'
                      e.currentTarget.style.borderColor = '#3BB77E'
                      e.currentTarget.style.color = '#3BB77E'
                    }}
                    onMouseLeave={e => {
                      e.currentTarget.style.background = '#fff'
                      e.currentTarget.style.borderColor = '#e0e0e0'
                      e.currentTarget.style.color = '#253D4E'
                    }}
                  >
                    {link.label}
                  </Link>
                ))}
              </div>
            </div>
          </div>

          {/* Help Strip */}
          <div className="box-contact-support pt-60 pb-50 background-gray-50 mb-30" style={{ borderRadius: 12 }}>
            <div className="row justify-content-center">
              <div className="col-lg-3 mb-30 text-center text-lg-start">
                <h3 className="mb-5">Need help?</h3>
                <p className="font-sm color-gray-700">Our friendly support team is here for you</p>
              </div>
              <div className="col-lg-3 text-center mb-30">
                <div className="box-image mb-15">
                  <img
                    src="/assets/imgs/page/contact/chat.svg"
                    alt="Chat to us"
                    style={{ width: 48, height: 48 }}
                    onError={e => { e.target.style.display = 'none' }}
                  />
                </div>
                <h4 className="mb-5">Chat to us</h4>
                <p className="font-sm color-gray-700 mb-5">Speak to our team directly.</p>
                <a className="font-sm color-gray-900" href="mailto:Info@kalses.com">Info@kalses.com</a>
              </div>
              <div className="col-lg-3 text-center mb-30">
                <div className="box-image mb-15">
                  <img
                    src="/assets/imgs/page/contact/call.svg"
                    alt="Call us"
                    style={{ width: 48, height: 48 }}
                    onError={e => { e.target.style.display = 'none' }}
                  />
                </div>
                <h4 className="mb-5">Call us</h4>
                <p className="font-sm color-gray-700 mb-5">Mon-Fri 24/7, Sat 9am-5pm</p>
                <a className="font-sm color-gray-900" href="tel:+19136670804">(913) 667-0804</a>
              </div>
              <div className="col-lg-3 text-center mb-30">
                <div className="box-image mb-15">
                  <img
                    src="/assets/imgs/page/contact/map.svg"
                    alt="Visit us"
                    style={{ width: 48, height: 48 }}
                    onError={e => { e.target.style.display = 'none' }}
                  />
                </div>
                <h4 className="mb-5">Visit us</h4>
                <p className="font-sm color-gray-700 mb-5">Kansas City, Missouri</p>
                <Link className="font-sm color-gray-900" to="/contact">Get directions</Link>
              </div>
            </div>
          </div>

        </div>
      </section>
    </main>
  )
}

export default NotFound
