import { useState } from 'react'
import { Link } from 'react-router-dom'

const jobListings = [
  {
    id: 1,
    title: 'Senior Frontend Developer',
    department: 'Engineering',
    type: 'Full-time',
    location: 'Remote',
    description:
      'We are looking for an experienced Frontend Developer to help build and maintain our React-based e-commerce platform. You will work closely with our design and backend teams to deliver fast, accessible, and pixel-perfect user interfaces.',
    responsibilities: [
      'Build and maintain reusable React components and pages',
      'Collaborate with designers to implement responsive UI/UX',
      'Optimize application performance and page load times',
      'Write clean, maintainable, and well-tested code',
      'Participate in code reviews and technical discussions',
    ],
    requirements: [
      '3+ years of experience with React.js',
      'Strong knowledge of HTML, CSS, and JavaScript (ES6+)',
      'Experience with REST APIs and state management (Context, Redux)',
      'Familiarity with Git version control',
      'Strong communication and collaboration skills',
    ],
  },
  {
    id: 2,
    title: 'Backend Developer (Laravel)',
    department: 'Engineering',
    type: 'Full-time',
    location: 'Remote',
    description:
      'Join our backend team and help build scalable, high-performance APIs that power the Kalses platform. You will be responsible for designing, implementing, and maintaining backend services using PHP and Laravel.',
    responsibilities: [
      'Design and develop RESTful APIs for the e-commerce platform',
      'Manage database schema design and migrations (MySQL)',
      'Integrate third-party services such as payment gateways and shipping providers',
      'Ensure application security, data integrity, and performance',
      'Write unit and integration tests for backend logic',
    ],
    requirements: [
      '3+ years of experience with PHP and Laravel',
      'Solid understanding of relational databases (MySQL/PostgreSQL)',
      'Experience with RESTful API design and development',
      'Knowledge of authentication patterns (JWT, OAuth)',
      'Experience with Docker and CI/CD pipelines is a plus',
    ],
  },
  {
    id: 3,
    title: 'Customer Support Specialist',
    department: 'Customer Success',
    type: 'Full-time',
    location: 'Hybrid – Kansas City, MO',
    description:
      'We are looking for an empathetic and proactive Customer Support Specialist to help our customers have the best possible shopping experience. You will handle inquiries, resolve issues, and work cross-functionally to improve customer satisfaction.',
    responsibilities: [
      'Respond to customer inquiries via email, chat, and phone',
      'Process returns, refunds, and order modifications',
      'Escalate complex issues to the appropriate teams',
      'Document recurring issues and suggest improvements',
      'Maintain a high customer satisfaction rating (CSAT)',
    ],
    requirements: [
      '1+ years of experience in customer support or service',
      'Excellent written and verbal communication skills',
      'Patience, empathy, and a customer-first mindset',
      'Ability to multitask and work in a fast-paced environment',
      'Experience with helpdesk tools (Zendesk, Freshdesk) is a plus',
    ],
  },
  {
    id: 4,
    title: 'Digital Marketing Manager',
    department: 'Marketing',
    type: 'Full-time',
    location: 'Remote',
    description:
      'Help grow the Kalses brand and customer base through data-driven digital marketing strategies. You will own our online marketing channels including SEO, paid ads, email campaigns, and social media to drive traffic and conversions.',
    responsibilities: [
      'Develop and execute digital marketing strategies across multiple channels',
      'Manage Google Ads, Meta Ads, and other paid campaigns',
      'Oversee SEO strategy and content marketing initiatives',
      'Plan and send email marketing campaigns (newsletters, promos)',
      'Track and analyze campaign performance with KPIs and reporting',
    ],
    requirements: [
      '3+ years of digital marketing experience (e-commerce preferred)',
      'Proficiency in Google Ads, Meta Business Suite, and analytics tools',
      'Strong understanding of SEO/SEM best practices',
      'Experience with email marketing platforms (Klaviyo, Mailchimp)',
      'Data-driven mindset with strong analytical skills',
    ],
  },
  {
    id: 5,
    title: 'Warehouse & Fulfillment Associate',
    department: 'Operations',
    type: 'Full-time',
    location: 'Kansas City, MO',
    description:
      'Join our operations team to help ensure our customers receive their orders accurately and on time. You will be responsible for receiving, picking, packing, and shipping orders from our Kansas City fulfillment facility.',
    responsibilities: [
      'Receive, verify, and shelve incoming inventory',
      'Pick and pack customer orders accurately and efficiently',
      'Maintain a clean and organized warehouse environment',
      'Operate warehouse equipment and scanning systems',
      'Assist with inventory counts and stock management',
    ],
    requirements: [
      'High school diploma or equivalent',
      'Ability to lift up to 50 lbs and stand for extended periods',
      'Attention to detail and accuracy in order fulfillment',
      'Reliable, punctual, and a strong work ethic',
      'Warehouse or retail experience is a plus',
    ],
  },
]

const benefits = [
  { icon: '🌍', title: 'Remote Friendly', desc: 'Many roles are fully remote or hybrid. Work from where you do your best work.' },
  { icon: '🏥', title: 'Health Benefits', desc: 'Comprehensive health, dental, and vision coverage for you and your family.' },
  { icon: '📈', title: 'Growth Opportunities', desc: 'We invest in your career. Regular performance reviews and promotion paths.' },
  { icon: '🎓', title: 'Learning Budget', desc: '$1,500 annual budget for courses, certifications, and professional development.' },
  { icon: '🕐', title: 'Flexible Hours', desc: 'Flexible scheduling for most roles. We trust you to manage your own time.' },
  { icon: '🎉', title: 'Team Culture', desc: 'Regular team events, company retreats, and a positive, inclusive workplace.' },
]

const Careers = () => {
  const [activeJob, setActiveJob] = useState(null)

  const toggleJob = (id) => {
    setActiveJob((prev) => (prev === id ? null : id))
  }

  return (
    <main className="main">
      {/* Breadcrumb */}
      <div className="section-box">
        <div className="breadcrumbs-div">
          <div className="container">
            <ul className="breadcrumb">
              <li><Link className="font-xs color-gray-1000" to="/">Home</Link></li>
              <li><span className="font-xs color-gray-500">Pages</span></li>
              <li><span className="font-xs color-gray-500">Careers</span></li>
            </ul>
          </div>
        </div>
      </div>

      <section className="section-box shop-template mt-30">
        <div className="container">
          <div className="row">
            <div className="col-lg-10 mx-auto page-content">

              {/* Hero */}
              <h2 className="text-center mb-20">Work with us</h2>
              <img
                className="mb-30"
                src="/assets/imgs/page/about/team-2.jpg"
                alt="Kalses Team"
                style={{ width: '100%', borderRadius: 8, maxHeight: 380, objectFit: 'cover' }}
                onError={e => { e.target.style.display = 'none' }}
              />
              <p className="font-sm color-gray-700 mb-20">
                At Kalses, we recognize that great talent has no borders. We are continually searching for bright, motivated
                individuals who are passionate about e-commerce, technology, and creating exceptional customer experiences.
                If you share our values of quality, innovation, and community, we want to hear from you.
              </p>

              {/* Programs & Internships */}
              <h5>Programs and Internships</h5>
              <p className="font-sm color-gray-700 mb-15">
                We offer internship and co-op programs for students and recent graduates across engineering, marketing, operations,
                and customer success. Our interns work alongside experienced team members on real projects with tangible impact.
                Many of our full-time employees started as Kalses interns — we love growing talent from within.
              </p>
              <p className="font-sm color-gray-700 mb-30">
                Internships are available on a rolling basis. To express interest, send your resume and a brief note about which
                department excites you most to <strong>careers@kalses.com</strong> with the subject line: <em>Internship Inquiry</em>.
              </p>

              {/* Benefits */}
              <h5>Why Work at Kalses?</h5>
              <p className="font-sm color-gray-700 mb-30">
                We take care of our people. Here are some of the benefits and perks that come with being part of the Kalses team:
              </p>
              <div className="row mb-50">
                {benefits.map((b) => (
                  <div key={b.title} className="col-lg-4 col-md-6 col-12 mb-30">
                    <div className="card-staff hover-up p-4" style={{ height: '100%' }}>
                      <div className="mb-10" style={{ fontSize: 36 }}>{b.icon}</div>
                      <h5 className="mb-5">{b.title}</h5>
                      <p className="font-md color-gray-500">{b.desc}</p>
                    </div>
                  </div>
                ))}
              </div>

              {/* Current Openings */}
              <h5>Current Openings</h5>
              <p className="font-sm color-gray-700 mb-30">
                We have openings across multiple departments. Browse the listings below and click to expand for full details,
                responsibilities, and requirements. To apply, email your resume and cover letter to <strong>careers@kalses.com</strong>.
              </p>

              <div className="mb-50">
                {jobListings.map((job) => (
                  <div
                    key={job.id}
                    className="mb-20"
                    style={{
                      border: '1px solid #e8e8e8',
                      borderRadius: 10,
                      overflow: 'hidden',
                      boxShadow: activeJob === job.id ? '0 4px 16px rgba(59,183,126,0.10)' : 'none',
                      transition: 'box-shadow 0.2s',
                    }}
                  >
                    {/* Job Header */}
                    <div
                      onClick={() => toggleJob(job.id)}
                      style={{
                        display: 'flex',
                        alignItems: 'center',
                        justifyContent: 'space-between',
                        padding: '20px 24px',
                        cursor: 'pointer',
                        background: activeJob === job.id ? '#f0fdf4' : '#fff',
                        transition: 'background 0.2s',
                      }}
                    >
                      <div>
                        <h5 className="mb-5" style={{ margin: 0 }}>{job.title}</h5>
                        <span className="font-sm color-gray-500">
                          {job.department} &nbsp;&middot;&nbsp; {job.location}
                        </span>
                      </div>
                      <div style={{ display: 'flex', alignItems: 'center', gap: 12 }}>
                        <span
                          style={{
                            background: '#f0fdf4',
                            color: '#3BB77E',
                            padding: '4px 14px',
                            borderRadius: 20,
                            fontSize: 12,
                            fontWeight: 600,
                            whiteSpace: 'nowrap',
                          }}
                        >
                          {job.type}
                        </span>
                        <span style={{ color: '#3BB77E', fontSize: 18, fontWeight: 700 }}>
                          {activeJob === job.id ? '−' : '+'}
                        </span>
                      </div>
                    </div>

                    {/* Job Detail Panel */}
                    {activeJob === job.id && (
                      <div style={{ padding: '0 24px 28px', borderTop: '1px solid #eee' }}>
                        <p className="font-sm color-gray-700" style={{ marginTop: 20, marginBottom: 16 }}>
                          {job.description}
                        </p>

                        <div className="row">
                          <div className="col-lg-6">
                            <h5 className="mb-10" style={{ fontSize: 15 }}>Responsibilities</h5>
                            <ul style={{ paddingLeft: 20, color: '#7E7E7E' }}>
                              {job.responsibilities.map((r, i) => (
                                <li key={i} className="font-sm mb-5">{r}</li>
                              ))}
                            </ul>
                          </div>
                          <div className="col-lg-6">
                            <h5 className="mb-10" style={{ fontSize: 15 }}>Requirements</h5>
                            <ul style={{ paddingLeft: 20, color: '#7E7E7E' }}>
                              {job.requirements.map((r, i) => (
                                <li key={i} className="font-sm mb-5">{r}</li>
                              ))}
                            </ul>
                          </div>
                        </div>

                        <div className="mt-20">
                          <a
                            href={`mailto:careers@kalses.com?subject=${encodeURIComponent(job.title + ' Application')}`}
                            className="btn btn-buy w-auto"
                          >
                            Apply for this Role
                          </a>
                          <span className="font-sm color-gray-500 ml-20" style={{ marginLeft: 16 }}>
                            Send resume to <strong>careers@kalses.com</strong>
                          </span>
                        </div>
                      </div>
                    )}
                  </div>
                ))}
              </div>

              {/* Behind the Mission */}
              <h5>Behind the Mission</h5>
              <p className="font-sm color-gray-700 mb-15">
                Kalses was founded on the belief that great shopping experiences start with great people. Every person on our team
                plays a direct role in delivering value to our customers — from the engineers who build our platform to the warehouse
                team that packs orders with care.
              </p>
              <p className="font-sm color-gray-700 mb-15">
                We foster a culture of ownership, open communication, and continuous learning. We celebrate wins together and tackle
                challenges as a unified team. Diversity, equity, and inclusion are not just words to us — they are actively embedded
                in how we hire, promote, and operate.
              </p>
              <p className="font-sm color-gray-700 mb-30">
                Whether you are just starting your career or bringing years of expertise, there is a place for you at Kalses. We look
                forward to learning what you can bring to our growing team.
              </p>

              {/* CTA */}
              <div
                style={{
                  background: '#f0fdf4',
                  border: '1px solid #bbf7d0',
                  borderRadius: 12,
                  padding: '32px 40px',
                  textAlign: 'center',
                }}
              >
                <h4 className="mb-10">Don't see a role that fits?</h4>
                <p className="font-sm color-gray-700 mb-20">
                  We're always looking for great talent. Send us your resume and tell us how you can contribute to the Kalses mission.
                </p>
                <a
                  href="mailto:careers@kalses.com?subject=General%20Application"
                  className="btn btn-buy w-auto"
                >
                  Send an Open Application
                </a>
              </div>

            </div>
          </div>
        </div>
      </section>
    </main>
  )
}

export default Careers
