import { Link } from 'react-router-dom'

const About = () => {
  return (
    <main className="main">
      {/* Breadcrumb */}
      <div className="section-box">
        <div className="breadcrumbs-div">
          <div className="container">
            <ul className="breadcrumb">
              <li><Link className="font-xs color-gray-1000" to="/">Home</Link></li>
              <li><span className="font-xs color-gray-500">Pages</span></li>
              <li><span className="font-xs color-gray-500">About Us</span></li>
            </ul>
          </div>
        </div>
      </div>

      <section className="section-box shop-template mt-30">
        <div className="container">
          <div className="row">
            <div className="col-lg-10 mx-auto">

              {/* Hero / Mission */}
              <h5 className="color-gray-500 mb-10">About us</h5>
              <h2>Welcome to Kalses LLC</h2>
              <div className="row mt-20">
                <div className="col-lg-6">
                  <p className="font-sm font-medium color-gray-700 mb-15">
                    At Kalses, we believe shopping should be simple, enjoyable, and tailored to meet the needs of your everyday life.
                    Based in Kansas City, Missouri, we are committed to providing exceptional customer service, high-quality products,
                    and a seamless online shopping experience.
                  </p>
                  <p className="font-sm font-medium color-gray-700 mb-15">
                    Whether you're looking for baby essentials, beauty products, pet supplies, snacks, or toys, Kalses has something
                    for everyone. Our diverse product range is carefully curated to bring you the best items at competitive prices.
                  </p>
                  <p className="font-sm font-medium color-gray-700 mb-15">
                    We're more than just an online store — we're a part of your community. We promise to keep innovating, growing, and
                    listening to your needs to serve you better every day.
                  </p>
                  <ul className="list-services mt-20">
                    <li className="hover-up">Exceptional customer service</li>
                    <li className="hover-up">High-quality products</li>
                    <li className="hover-up">Fast &amp; reliable shipping</li>
                    <li className="hover-up">Seamless shopping experience</li>
                  </ul>
                </div>
                <div className="col-lg-6">
                  <img
                    src="/assets/imgs/page/about/img.png"
                    alt="Kalses"
                    style={{ width: '100%', borderRadius: 8 }}
                    onError={e => { e.target.style.display = 'none' }}
                  />
                </div>
              </div>

              {/* Core Values / Company Pillars */}
              <div className="box-contact-support pt-80 pb-50 pl-50 pr-50 background-gray-50 mt-50 mb-90">
                <div className="row">
                  <div className="col-lg-3 mb-30 text-center text-lg-start">
                    <h4 className="mb-5">Quality Products</h4>
                    <p className="font-md color-gray-700">Carefully curated selection of high-quality items.</p>
                  </div>
                  <div className="col-lg-3 mb-30 text-center text-lg-start">
                    <h4 className="mb-5">Fast Shipping</h4>
                    <p className="font-md color-gray-700 mb-5">Quick and reliable delivery across the United States.</p>
                  </div>
                  <div className="col-lg-3 mb-30 text-center text-lg-start">
                    <h4 className="mb-5">24/7 Support</h4>
                    <p className="font-md color-gray-700 mb-5">Our customer service team is here to help you anytime.</p>
                  </div>
                  <div className="col-lg-3 mb-30 text-center text-lg-start">
                    <h4 className="mb-5">Secure Shopping</h4>
                    <p className="font-md color-gray-700 mb-5">Safe and secure online shopping experience.</p>
                  </div>
                </div>
              </div>

              {/* Company Stats */}
              <h5 className="color-gray-500 mb-10">Our Numbers</h5>
              <h2 className="mb-40">Trusted by thousands of happy customers</h2>
              <div className="row mb-50">
                <div className="col-lg-3 col-md-6 col-12 mb-30 text-center">
                  <div className="card-staff hover-up p-4">
                    <h2 className="color-brand-3 mb-5">5+</h2>
                    <h5 className="mb-5">Years in Business</h5>
                    <p className="font-md color-gray-500">Proudly serving customers since 2019</p>
                  </div>
                </div>
                <div className="col-lg-3 col-md-6 col-12 mb-30 text-center">
                  <div className="card-staff hover-up p-4">
                    <h2 className="color-brand-3 mb-5">50K+</h2>
                    <h5 className="mb-5">Happy Customers</h5>
                    <p className="font-md color-gray-500">Across the United States and beyond</p>
                  </div>
                </div>
                <div className="col-lg-3 col-md-6 col-12 mb-30 text-center">
                  <div className="card-staff hover-up p-4">
                    <h2 className="color-brand-3 mb-5">10K+</h2>
                    <h5 className="mb-5">Products Listed</h5>
                    <p className="font-md color-gray-500">Across dozens of product categories</p>
                  </div>
                </div>
                <div className="col-lg-3 col-md-6 col-12 mb-30 text-center">
                  <div className="card-staff hover-up p-4">
                    <h2 className="color-brand-3 mb-5">500+</h2>
                    <h5 className="mb-5">Trusted Vendors</h5>
                    <p className="font-md color-gray-500">Verified sellers and brand partners</p>
                  </div>
                </div>
              </div>

              {/* Product Categories / Team Section */}
              <h5 className="color-gray-500 mb-10">Our Product Categories</h5>
              <h2 className="mb-40">Shop from our wide range of quality products</h2>
              <div className="row mb-50">
                <div className="col-lg-4 col-md-6 col-12 mb-30">
                  <div className="card-staff hover-up text-center p-4">
                    <div className="mb-15" style={{ fontSize: 40 }}>🏠</div>
                    <h5>Health &amp; Household</h5>
                    <p className="font-md color-gray-500">Cleaning supplies and household essentials</p>
                  </div>
                </div>
                <div className="col-lg-4 col-md-6 col-12 mb-30">
                  <div className="card-staff hover-up text-center p-4">
                    <div className="mb-15" style={{ fontSize: 40 }}>💄</div>
                    <h5>Beauty &amp; Personal Care</h5>
                    <p className="font-md color-gray-500">Skincare, cosmetics, and personal care items</p>
                  </div>
                </div>
                <div className="col-lg-4 col-md-6 col-12 mb-30">
                  <div className="card-staff hover-up text-center p-4">
                    <div className="mb-15" style={{ fontSize: 40 }}>🐾</div>
                    <h5>Pet Supplies</h5>
                    <p className="font-md color-gray-500">Everything for your furry friends</p>
                  </div>
                </div>
                <div className="col-lg-4 col-md-6 col-12 mb-30">
                  <div className="card-staff hover-up text-center p-4">
                    <div className="mb-15" style={{ fontSize: 40 }}>👶</div>
                    <h5>Baby Products</h5>
                    <p className="font-md color-gray-500">Quality essentials for your little ones</p>
                  </div>
                </div>
                <div className="col-lg-4 col-md-6 col-12 mb-30">
                  <div className="card-staff hover-up text-center p-4">
                    <div className="mb-15" style={{ fontSize: 40 }}>🛒</div>
                    <h5>Grocery &amp; Gourmet Food</h5>
                    <p className="font-md color-gray-500">Snacks and gourmet food items</p>
                  </div>
                </div>
                <div className="col-lg-4 col-md-6 col-12 mb-30">
                  <div className="card-staff hover-up text-center p-4">
                    <div className="mb-15" style={{ fontSize: 40 }}>🎮</div>
                    <h5>Toys &amp; Games</h5>
                    <p className="font-md color-gray-500">Fun and educational toys for all ages</p>
                  </div>
                </div>
              </div>

              {/* Our Values */}
              <div className="border-1 mb-50 mt-30"></div>
              <h5 className="color-gray-500 mb-10">Our Values</h5>
              <h2 className="mb-40">What drives us every day</h2>
              <div className="row mb-50">
                <div className="col-lg-3 col-md-6 col-12 mb-30">
                  <div className="card-staff hover-up text-center p-4" style={{ height: '100%' }}>
                    <div className="mb-15" style={{ fontSize: 40 }}>🎯</div>
                    <h5 className="mb-10">Quality First</h5>
                    <p className="font-md color-gray-500">We never compromise on product quality. Every item is verified before listing on our platform.</p>
                  </div>
                </div>
                <div className="col-lg-3 col-md-6 col-12 mb-30">
                  <div className="card-staff hover-up text-center p-4" style={{ height: '100%' }}>
                    <div className="mb-15" style={{ fontSize: 40 }}>💡</div>
                    <h5 className="mb-10">Innovation</h5>
                    <p className="font-md color-gray-500">We continuously improve our platform to give you the best, most seamless shopping experience.</p>
                  </div>
                </div>
                <div className="col-lg-3 col-md-6 col-12 mb-30">
                  <div className="card-staff hover-up text-center p-4" style={{ height: '100%' }}>
                    <div className="mb-15" style={{ fontSize: 40 }}>🤝</div>
                    <h5 className="mb-10">Trust</h5>
                    <p className="font-md color-gray-500">Transparent pricing, honest reviews, and no hidden fees — ever. Your trust is our top priority.</p>
                  </div>
                </div>
                <div className="col-lg-3 col-md-6 col-12 mb-30">
                  <div className="card-staff hover-up text-center p-4" style={{ height: '100%' }}>
                    <div className="mb-15" style={{ fontSize: 40 }}>🌍</div>
                    <h5 className="mb-10">Community</h5>
                    <p className="font-md color-gray-500">Supporting local vendors and sustainable products whenever possible to strengthen our community.</p>
                  </div>
                </div>
              </div>

              {/* Visit Our Office */}
              <div className="border-1 mb-80 mt-50"></div>
              <h2 className="mb-5">Visit Our Office</h2>
              <p className="font-sm color-gray-700">We'd love to hear from you</p>
              <div className="box-contact-address pt-30 pb-50">
                <div className="row">
                  <div className="col-lg-4">
                    <div className="mb-30">
                      <h4>Kansas City Office</h4>
                      <p className="font-sm color-gray-700">
                        8301 State Line Rd. Ste 220 #2547<br />
                        Kansas City, Missouri 64114, USA
                      </p>
                    </div>
                  </div>
                  <div className="col-lg-4">
                    <div className="mb-30">
                      <h4>Contact Information</h4>
                      <p className="font-sm color-gray-700">
                        <strong>Phone:</strong> (913) 667-0804<br />
                        <strong>Email:</strong> Info@kalses.com
                      </p>
                    </div>
                  </div>
                  <div className="col-lg-4">
                    <div className="mb-30">
                      <h4>Business Hours</h4>
                      <p className="font-sm color-gray-700">
                        Monday - Friday: 24/7<br />
                        Saturday: 9am - 5pm
                      </p>
                    </div>
                  </div>
                </div>
              </div>

            </div>
          </div>
        </div>

        {/* Contact Support Banner */}
        <div className="box-contact-support pt-80 pb-50 background-gray-50">
          <div className="container">
            <div className="row">
              <div className="col-lg-1"></div>
              <div className="col-lg-10">
                <div className="row">
                  <div className="col-lg-3 mb-30 text-center text-lg-start">
                    <h3 className="mb-5">We'd love to hear from you</h3>
                    <p className="font-sm color-gray-700">Chat with our friendly team</p>
                  </div>
                  <div className="col-lg-3 text-center mb-30">
                    <div className="box-image mb-20">
                      <img src="/assets/imgs/page/contact/chat.svg" alt="Chat to sales" onError={e => { e.target.style.display = 'none' }} />
                    </div>
                    <h4 className="mb-5">Chat to sales</h4>
                    <p className="font-sm color-gray-700 mb-5">Speak to our team.</p>
                    <a className="font-sm color-gray-900" href="mailto:Info@kalses.com">Info@kalses.com</a>
                  </div>
                  <div className="col-lg-3 text-center mb-30">
                    <div className="box-image mb-20">
                      <img src="/assets/imgs/page/contact/call.svg" alt="Call us" onError={e => { e.target.style.display = 'none' }} />
                    </div>
                    <h4 className="mb-5">Call us</h4>
                    <p className="font-sm color-gray-700 mb-5">Mon-Fri 24/7, Sat 9am-5pm</p>
                    <a className="font-sm color-gray-900" href="tel:+19136670804">(913) 667-0804</a>
                  </div>
                  <div className="col-lg-3 text-center mb-30">
                    <div className="box-image mb-20">
                      <img src="/assets/imgs/page/contact/map.svg" alt="Visit us" onError={e => { e.target.style.display = 'none' }} />
                    </div>
                    <h4 className="mb-5">Visit us</h4>
                    <p className="font-sm color-gray-700 mb-5">Visit our office</p>
                    <span className="font-sm color-gray-900">
                      8301 State Line Rd. Ste 220 #2547<br />
                      Kansas City, Missouri 64114, USA
                    </span>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </main>
  )
}

export default About
