import { createContext, useContext, useState, useEffect } from 'react'
import { login as loginApi, register as registerApi, logout as logoutApi, getProfile } from '../services/api'

const AuthContext = createContext()

export const AuthProvider = ({ children }) => {
  const [user, setUser] = useState(null)
  const [loading, setLoading] = useState(true)

  useEffect(() => {
    const token = localStorage.getItem('token')
    const savedUser = localStorage.getItem('user')
    if (token && savedUser) {
      try { setUser(JSON.parse(savedUser)) } catch {}
      getProfile()
        .then(res => {
          const u = res.data.data || res.data.user
          setUser(u)
          localStorage.setItem('user', JSON.stringify(u))
        })
        .catch(() => {
          localStorage.removeItem('token')
          localStorage.removeItem('user')
          setUser(null)
        })
        .finally(() => setLoading(false))
    } else {
      setLoading(false)
    }
  }, [])

  const login = async (email, password) => {
    const res = await loginApi({ email, password })
    const token = res.data.token || res.data.access_token
    const u = res.data.user || res.data.data
    localStorage.setItem('token', token)
    localStorage.setItem('user', JSON.stringify(u))
    setUser(u)
    return u
  }

  const register = async (data) => {
    const res = await registerApi(data)
    const token = res.data.token || res.data.access_token
    const u = res.data.user || res.data.data
    localStorage.setItem('token', token)
    localStorage.setItem('user', JSON.stringify(u))
    setUser(u)
    return u
  }

  const logout = async () => {
    try { await logoutApi() } catch {}
    localStorage.removeItem('token')
    localStorage.removeItem('user')
    setUser(null)
  }

  const isLoggedIn = !!user

  return (
    <AuthContext.Provider value={{ user, setUser, loading, login, register, logout, isLoggedIn }}>
      {children}
    </AuthContext.Provider>
  )
}

export const useAuth = () => useContext(AuthContext)
