import { Navigate, useLocation } from 'react-router-dom'
import { useAuth } from '../../context/AuthContext'

const ProtectedRoute = ({ children }) => {
  const { isLoggedIn, loading } = useAuth()
  const location = useLocation()

  if (loading) return <div style={{ display: 'flex', justifyContent: 'center', padding: 60 }}><div className="loader"></div></div>
  if (!isLoggedIn) return <Navigate to="/login" state={{ from: location }} replace />
  return children
}
export default ProtectedRoute
