const Pagination = ({ currentPage, lastPage, onPageChange }) => {
  if (lastPage <= 1) return null
  const pages = []
  const start = Math.max(1, currentPage - 2)
  const end = Math.min(lastPage, currentPage + 2)
  for (let i = start; i <= end; i++) pages.push(i)

  return (
    <div className="pagination-area mt-20 mb-sm-5 mb-lg-0">
      <nav aria-label="Page navigation">
        <ul className="pagination justify-content-start">
          <li className={`page-item${currentPage === 1 ? ' disabled' : ''}`}>
            <button className="page-link" onClick={() => onPageChange(currentPage - 1)}>
              <i className="fi-rs-arrow-small-left"></i>
            </button>
          </li>
          {start > 1 && (
            <>
              <li className="page-item"><button className="page-link" onClick={() => onPageChange(1)}>1</button></li>
              {start > 2 && <li className="page-item disabled"><span className="page-link">...</span></li>}
            </>
          )}
          {pages.map(p => (
            <li key={p} className={`page-item${p === currentPage ? ' active' : ''}`}>
              <button className="page-link" onClick={() => onPageChange(p)}>{p}</button>
            </li>
          ))}
          {end < lastPage && (
            <>
              {end < lastPage - 1 && <li className="page-item disabled"><span className="page-link">...</span></li>}
              <li className="page-item"><button className="page-link" onClick={() => onPageChange(lastPage)}>{lastPage}</button></li>
            </>
          )}
          <li className={`page-item${currentPage === lastPage ? ' disabled' : ''}`}>
            <button className="page-link" onClick={() => onPageChange(currentPage + 1)}>
              <i className="fi-rs-arrow-small-right"></i>
            </button>
          </li>
        </ul>
      </nav>
    </div>
  )
}
export default Pagination
