import { Link } from 'react-router-dom'
import { useState } from 'react'
import { subscribeNewsletter } from '../../services/api'

const Footer = () => {
  const [email, setEmail] = useState('')
  const [msg, setMsg] = useState('')

  const handleNewsletter = async (e) => {
    e.preventDefault()
    try {
      await subscribeNewsletter(email)
      setMsg('Thank you for subscribing!')
      setEmail('')
    } catch {
      setMsg('Subscription failed. Please try again.')
    }
  }

  return (
    <footer className="footer">
      <div className="footer-1">
        <div className="container">
          <div className="row">
            <div className="col-lg-3 width-25 mb-30">
              <h4 className="mb-30 color-gray-1000">Contact</h4>
              <div className="font-md mb-20 color-gray-900">
                <strong className="font-md-bold">Address:</strong> 123 Main Street, City, Country
              </div>
              <div className="font-md mb-20 color-gray-900">
                <strong className="font-md-bold">Phone:</strong> 1900-888
              </div>
              <div className="font-md mb-20 color-gray-900">
                <strong className="font-md-bold">E-mail:</strong> info@kalses.com
              </div>
              <div className="font-md mb-20 color-gray-900">
                <strong className="font-md-bold">Hours:</strong> Mon–Fri 24/7, Sat 9am–5pm
              </div>
              <div className="mt-30">
                <a className="icon-socials icon-facebook" href="#" aria-label="Facebook"></a>
                <a className="icon-socials icon-instagram" href="#" aria-label="Instagram"></a>
                <a className="icon-socials icon-twitter" href="#" aria-label="Twitter"></a>
                <a className="icon-socials icon-linkedin" href="#" aria-label="LinkedIn"></a>
              </div>
            </div>
            <div className="col-lg-3 width-20 mb-30">
              <h4 className="mb-30 color-gray-1000">Company</h4>
              <ul className="menu-footer">
                <li><Link to="/about">About Us</Link></li>
                <li><Link to="/careers">Careers</Link></li>
                <li><Link to="/contact">Contact Us</Link></li>
                <li><Link to="/terms">Terms &amp; Conditions</Link></li>
                <li><Link to="/terms">Privacy Policy</Link></li>
              </ul>
            </div>
            <div className="col-lg-3 width-16 mb-30">
              <h4 className="mb-30 color-gray-1000">Shop</h4>
              <ul className="menu-footer">
                <li><Link to="/shop">All Products</Link></li>
                <li><Link to="/vendors">Vendors</Link></li>
                <li><Link to="/wholesale">Wholesale (B2B)</Link></li>
                <li><Link to="/compare">Compare</Link></li>
              </ul>
            </div>
            <div className="col-lg-3 width-16 mb-30">
              <h4 className="mb-30 color-gray-1000">My Account</h4>
              <ul className="menu-footer">
                <li><Link to="/account">My Account</Link></li>
                <li><Link to="/account?tab=orders">My Orders</Link></li>
                <li><Link to="/wishlist">My Wishlist</Link></li>
                <li><Link to="/cart">Shopping Cart</Link></li>
                <li><Link to="/login">Sign In</Link></li>
              </ul>
            </div>
            <div className="col-lg-3 width-20 mb-30">
              <h4 className="mb-30 color-gray-1000">Newsletter</h4>
              <p className="font-sm color-gray-700 mb-20">Subscribe for the latest deals and updates.</p>
              <form onSubmit={handleNewsletter}>
                <div className="form-group d-flex">
                  <input
                    className="form-control font-xs mr-10"
                    type="email"
                    placeholder="Your email address"
                    value={email}
                    onChange={e => setEmail(e.target.value)}
                    required
                  />
                </div>
                <button className="btn btn-buy w-100 mt-10" type="submit">Subscribe</button>
                {msg && <p className="font-xs mt-5" style={{ color: msg.includes('Thank') ? '#3BB77E' : '#f00' }}>{msg}</p>}
              </form>
            </div>
          </div>
        </div>
      </div>

      <div className="footer-2">
        <div className="footer-bottom-1">
          <div className="container">
            <div className="footer-2-top mb-20">
              <Link to="/"><img alt="Kalses" src="/assets/imgs/template/logo-2.png"
                onError={e => { e.target.onerror = null; e.target.src = '/assets/imgs/template/logo.svg' }} /></Link>
              <Link className="font-xs color-gray-1000" to="/">Home</Link>
              <Link className="font-xs color-gray-1000" to="/shop">Shop</Link>
              <Link className="font-xs color-gray-1000" to="/wholesale">Wholesale</Link>
              <Link className="font-xs color-gray-1000" to="/about">About Us</Link>
              <Link className="font-xs color-gray-1000" to="/contact">Contact</Link>
            </div>
          </div>
        </div>
        <div className="container">
          <div className="footer-bottom mt-20">
            <div className="row">
              <div className="col-lg-6 col-md-12 text-center text-lg-start">
                <span className="color-gray-900 font-sm">
                  Copyright &copy; {new Date().getFullYear()} Kalses LLC. All rights reserved.
                </span>
              </div>
              <div className="col-lg-6 col-md-12 text-center text-lg-end">
                <ul className="menu-bottom">
                  <li><Link className="font-sm color-gray-900" to="/terms">Conditions of Use</Link></li>
                  <li><Link className="font-sm color-gray-900" to="/terms">Privacy Notice</Link></li>
                  <li><Link className="font-sm color-gray-900" to="/careers">Careers</Link></li>
                </ul>
              </div>
            </div>
          </div>
        </div>
      </div>
    </footer>
  )
}
export default Footer
