import { BrowserRouter, Routes, Route } from 'react-router-dom'
import { Toaster } from 'react-hot-toast'
import { HelmetProvider } from 'react-helmet-async'
import { AuthProvider } from './context/AuthContext'
import { CartProvider } from './context/CartContext'
import { WishlistProvider } from './context/WishlistContext'
import Layout from './components/layout/Layout'
import Home from './pages/Home'
import Shop from './pages/Shop'
import ProductDetail from './pages/ProductDetail'
import Cart from './pages/Cart'
import Checkout from './pages/Checkout'
import Login from './pages/Login'
import Register from './pages/Register'
import Account from './pages/Account'
import Wishlist from './pages/Wishlist'
import Compare from './pages/Compare'
import VendorList from './pages/VendorList'
import VendorDetail from './pages/VendorDetail'
import Wholesale from './pages/Wholesale'
import WholesaleDashboard from './pages/WholesaleDashboard'
import About from './pages/About'
import Contact from './pages/Contact'
import Careers from './pages/Careers'
import Terms from './pages/Terms'
import NotFound from './pages/NotFound'
import ForgotPassword from './pages/ForgotPassword'
import ResetPassword from './pages/ResetPassword'
import CheckoutSuccess from './pages/CheckoutSuccess'
import ProtectedRoute from './components/ui/ProtectedRoute'

function App() {
  return (
    <HelmetProvider>
      <BrowserRouter>
        <AuthProvider>
          <CartProvider>
            <WishlistProvider>
              <Toaster position="top-right" toastOptions={{ duration: 3000 }} />
              <Routes>
                <Route path="/" element={<Layout />}>
                  <Route index element={<Home />} />
                  <Route path="shop" element={<Shop />} />
                  <Route path="shop/category/:slug" element={<Shop />} />
                  <Route path="product/:slug" element={<ProductDetail />} />
                  <Route path="cart" element={<Cart />} />
                  <Route path="wishlist" element={<Wishlist />} />
                  <Route path="compare" element={<Compare />} />
                  <Route path="vendors" element={<VendorList />} />
                  <Route path="vendors/:id" element={<VendorDetail />} />
                  <Route path="wholesale" element={<Wholesale />} />
                  <Route path="about" element={<About />} />
                  <Route path="contact" element={<Contact />} />
                  <Route path="careers" element={<Careers />} />
                  <Route path="terms" element={<Terms />} />
                  <Route path="login" element={<Login />} />
                  <Route path="register" element={<Register />} />
                  <Route path="forgot-password" element={<ForgotPassword />} />
                  <Route path="reset-password" element={<ResetPassword />} />
                  <Route path="checkout" element={
                    <ProtectedRoute><Checkout /></ProtectedRoute>
                  } />
                  <Route path="checkout/success" element={
                    <ProtectedRoute><CheckoutSuccess /></ProtectedRoute>
                  } />
                  <Route path="account/*" element={
                    <ProtectedRoute><Account /></ProtectedRoute>
                  } />
                  <Route path="wholesale-dashboard" element={
                    <ProtectedRoute><WholesaleDashboard /></ProtectedRoute>
                  } />
                  <Route path="*" element={<NotFound />} />
                </Route>
              </Routes>
            </WishlistProvider>
          </CartProvider>
        </AuthProvider>
      </BrowserRouter>
    </HelmetProvider>
  )
}

export default App
