/**
 * Footer Categories Loader
 * Dynamically loads parent categories with their children from the API
 */
(function() {
    'use strict';

    document.addEventListener('DOMContentLoaded', function() {
        const API_BASE = (typeof KalsesAPI !== 'undefined' && KalsesAPI.getBaseUrl)
            ? KalsesAPI.getBaseUrl()
            : (window.KALSES_API_BASE || 'http://127.0.0.1:8000/api/v1');

        const container = document.getElementById('footer-categories-container');
        if (!container) return;

        // Fallback static content
        const fallbackHTML = '<div class="footer-2-bottom">' +
            '<div class="head-left-footer"><h6 class="color-gray-1000">Beauty & Personal Care:</h6></div>' +
            '<div class="tags-footer">' +
            '<a href="shop-grid.html">Skincare</a>' +
            '<a href="shop-grid.html">Haircare</a>' +
            '<a href="shop-grid.html">Makeup</a>' +
            '<a href="shop-grid.html">Fragrances</a>' +
            '<a href="shop-grid.html">Bath & Body</a>' +
            '<a href="shop-grid.html">Oral Care</a>' +
            '<a href="shop-grid.html">Men\'s Grooming</a>' +
            '<a href="shop-grid.html">Nail Care</a>' +
            '<a href="shop-grid.html">Tools & Accessories</a>' +
            '<a href="shop-grid.html">Feminine Care</a>' +
            '<a href="shop-grid.html">Deodorants</a>' +
            '<a href="shop-grid.html">Sun Care</a>' +
            '<a href="shop-grid.html">Hair Styling</a>' +
            '<a href="shop-grid.html">Shaving</a>' +
            '<a href="shop-grid.html">Lip Care</a>' +
            '</div></div>' +
            '<div class="footer-2-bottom">' +
            '<div class="head-left-footer"><h6 class="color-gray-1000">Health & Household:</h6></div>' +
            '<div class="tags-footer">' +
            '<a href="shop-grid.html">Vitamins & Supplements</a>' +
            '<a href="shop-grid.html">First Aid</a>' +
            '<a href="shop-grid.html">Medical Supplies</a>' +
            '<a href="shop-grid.html">Household Cleaning</a>' +
            '<a href="shop-grid.html">Laundry Supplies</a>' +
            '<a href="shop-grid.html">Paper Products</a>' +
            '<a href="shop-grid.html">Air Fresheners</a>' +
            '<a href="shop-grid.html">Batteries</a>' +
            '<a href="shop-grid.html">Light Bulbs</a>' +
            '<a href="shop-grid.html">Pest Control</a>' +
            '<a href="shop-grid.html">Hand Sanitizers</a>' +
            '<a href="shop-grid.html">Face Masks</a>' +
            '<a href="shop-grid.html">Wellness</a>' +
            '<a href="shop-grid.html">Baby Care</a>' +
            '<a href="shop-grid.html">Pet Supplies</a>' +
            '</div></div>';

        fetch(API_BASE + '/categories')
            .then(function(r) { return r.json(); })
            .then(function(data) {
                if (data.success && data.data && data.data.length > 0) {
                    const categories = data.data;
                    const parents = categories.filter(function(c) { return !c.parent_id; });

                    if (parents.length === 0) {
                        container.innerHTML = fallbackHTML;
                        return;
                    }

                    let html = '';
                    // Show first 2 parent categories with their children
                    parents.slice(0, 2).forEach(function(parent) {
                        const children = categories.filter(function(c) { return c.parent_id === parent.id; });

                        html += '<div class="footer-2-bottom">' +
                            '<div class="head-left-footer">' +
                            '<h6 class="color-gray-1000">' + parent.name + ':</h6>' +
                            '</div>' +
                            '<div class="tags-footer">';

                        if (children.length > 0) {
                            children.forEach(function(child) {
                                html += '<a href="shop-grid.html?category=' + child.slug + '">' + child.name + '</a>';
                            });
                        } else {
                            html += '<a href="shop-grid.html?category=' + parent.slug + '">' + parent.name + '</a>';
                        }

                        html += '</div></div>';
                    });

                    container.innerHTML = html;
                } else {
                    container.innerHTML = fallbackHTML;
                }
            })
            .catch(function(err) {
                console.error('Error loading footer categories:', err);
                container.innerHTML = fallbackHTML;
            });
    });
})();
