import js from '@eslint/js'
import globals from 'globals'
import reactHooks from 'eslint-plugin-react-hooks'
import reactRefresh from 'eslint-plugin-react-refresh'
import { defineConfig, globalIgnores } from 'eslint/config'

export default defineConfig([
  globalIgnores(['dist', 'public']),
  {
    files: ['**/*.{js,jsx}'],
    extends: [
      js.configs.recommended,
      reactHooks.configs.flat.recommended,
      reactRefresh.configs.vite,
    ],
    languageOptions: {
      ecmaVersion: 2020,
      globals: globals.browser,
      parserOptions: {
        ecmaVersion: 'latest',
        ecmaFeatures: { jsx: true },
        sourceType: 'module',
      },
    },
    rules: {
      'no-unused-vars': ['error', { varsIgnorePattern: '^[A-Z_]', argsIgnorePattern: '^_' }],
      // Allow empty catch blocks (intentional silent-fail pattern)
      'no-empty': ['error', { allowEmptyCatch: true }],
      // setLoading(true) before async calls inside useEffect is standard practice
      'react-hooks/set-state-in-effect': 'off',
      // Context files export both Provider and hook - common pattern, downgrade to warn
      'react-refresh/only-export-components': ['warn', { allowConstantExport: true }],
    },
  },
])
