<?php

namespace Tests\Feature;

use Tests\TestCase;

class ExampleTest extends TestCase
{
    public function test_products_api_returns_successful_response()
    {
        $response = $this->getJson('/api/v1/products');

        $response->assertStatus(200)
                 ->assertJsonStructure(['data', 'total', 'last_page', 'current_page']);
    }

    public function test_categories_api_returns_successful_response()
    {
        $response = $this->getJson('/api/v1/categories');

        $response->assertStatus(200);
    }

    public function test_settings_api_returns_successful_response()
    {
        $response = $this->getJson('/api/v1/settings');

        $response->assertStatus(200);
    }

    public function test_cart_requires_auth()
    {
        $response = $this->getJson('/api/v1/cart');

        $response->assertStatus(401);
    }

    public function test_orders_requires_auth()
    {
        $response = $this->getJson('/api/v1/orders');

        $response->assertStatus(401);
    }

    public function test_admin_stats_requires_admin()
    {
        $response = $this->getJson('/api/v1/admin/stats');

        $response->assertStatus(401);
    }
}
