<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<style>
body { font-family: Arial, sans-serif; background: #f5f5f5; margin: 0; padding: 20px; }
.container { max-width: 600px; margin: 0 auto; background: #fff; border-radius: 8px; overflow: hidden; }
.header { background: #3BB77E; padding: 30px; text-align: center; }
.header h1 { color: #fff; margin: 0; font-size: 24px; }
.body { padding: 30px; }
.btn { display: inline-block; background: #3BB77E; color: #fff !important; padding: 14px 28px; border-radius: 6px; text-decoration: none; font-weight: bold; margin: 20px 0; }
.footer { background: #f5f5f5; padding: 20px; text-align: center; color: #888; font-size: 12px; }
</style>
</head>
<body>
<div class="container">
  <div class="header"><h1>Kalses Store</h1></div>
  <div class="body">
    <h2>Reset Your Password</h2>
    <p>Hi <?php echo e($user->name); ?>,</p>
    <p>We received a request to reset your password. Click the button below to create a new password. This link expires in 60 minutes.</p>
    <a href="<?php echo e($resetUrl); ?>" class="btn">Reset Password</a>
    <p>If you did not request a password reset, please ignore this email.</p>
    <p>Or copy this link: <br><small><?php echo e($resetUrl); ?></small></p>
  </div>
  <div class="footer">&copy; <?php echo e(date('Y')); ?> Kalses Store. All rights reserved.</div>
</div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\kalsesv2\backend\resources\views/emails/password-reset.blade.php ENDPATH**/ ?>