<?php

use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\CartController;
use App\Http\Controllers\Api\CategoryController;
use App\Http\Controllers\Api\CompareController;
use App\Http\Controllers\Api\ContactController;
use App\Http\Controllers\Api\CouponController;
use App\Http\Controllers\Api\NewsletterController;
use App\Http\Controllers\Api\OrderController;
use App\Http\Controllers\Api\ProductController;
use App\Http\Controllers\Api\SettingController;
use App\Http\Controllers\Api\VendorController;
use App\Http\Controllers\Api\WholesaleController;
use App\Http\Controllers\Api\WishlistController;
use App\Http\Controllers\Api\PaymentController;
use Illuminate\Support\Facades\Route;

// Public Routes
Route::post('/auth/register', [AuthController::class, 'register']);
Route::post('/auth/login',    [AuthController::class, 'login']);

Route::get('/products',              [ProductController::class, 'index']);
Route::get('/products/{slug}',       [ProductController::class, 'show']);
Route::get('/products/{id}/reviews', [ProductController::class, 'reviews']);

Route::get('/categories',        [CategoryController::class, 'index']);
Route::get('/categories/{slug}', [CategoryController::class, 'show']);

Route::get('/vendors',      [VendorController::class, 'index']);
Route::get('/vendors/{id}', [VendorController::class, 'show']);

Route::get('/settings', [SettingController::class, 'settings']);
Route::get('/sliders',  [SettingController::class, 'sliders']);
Route::get('/banners',  [SettingController::class, 'banners']);

Route::post('/newsletter/subscribe', [NewsletterController::class, 'subscribe']);
Route::post('/contact',              [ContactController::class, 'store']);


// Password reset
Route::post('/auth/forgot-password', [AuthController::class, 'forgotPassword']);
Route::post('/auth/reset-password',  [AuthController::class, 'resetPassword']);

// Authenticated Routes
Route::middleware('auth:sanctum')->group(function () {
    Route::post('/auth/logout',  [AuthController::class, 'logout']);
    Route::get('/auth/profile',  [AuthController::class, 'profile']);
    Route::put('/auth/profile',  [AuthController::class, 'updateProfile']);
    Route::put('/auth/password', [AuthController::class, 'changePassword']);

    Route::get('/cart',         [CartController::class, 'index']);
    Route::post('/cart',        [CartController::class, 'store']);
    Route::put('/cart/{id}',    [CartController::class, 'update']);
    Route::delete('/cart/{id}', [CartController::class, 'destroy']);
    Route::delete('/cart',      [CartController::class, 'clear']);

    Route::get('/wishlist',                [WishlistController::class, 'index']);
    Route::post('/wishlist',               [WishlistController::class, 'store']);
    Route::delete('/wishlist/{productId}', [WishlistController::class, 'destroy']);

    Route::get('/compare',                [CompareController::class, 'index']);
    Route::post('/compare',               [CompareController::class, 'store']);
    Route::delete('/compare/{productId}', [CompareController::class, 'destroy']);
    Route::delete('/compare',             [CompareController::class, 'clear']);

    Route::get('/orders',             [OrderController::class, 'index']);
    Route::get('/orders/{id}',        [OrderController::class, 'show']);
    Route::post('/checkout',          [OrderController::class, 'checkout']);
    Route::put('/orders/{id}/cancel', [OrderController::class, 'cancel']);

    Route::post('/products/{id}/reviews', [ProductController::class, 'addReview']);

    Route::post('/wholesale/apply', [WholesaleController::class, 'apply']);
    Route::get('/wholesale/status', [WholesaleController::class, 'status']);
    Route::get('/wholesale/orders', [WholesaleController::class, 'orders']);


    // Stripe Payment
    Route::post('/payment/stripe-session', [PaymentController::class, 'createStripeSession']);
    Route::post('/payment/stripe-verify',  [PaymentController::class, 'verifyStripeSession']);

    Route::post('/coupons/apply',    [CouponController::class, 'apply']);
    Route::delete('/coupons/remove', [CouponController::class, 'remove']);
});

// Admin Routes
use App\Http\Controllers\Admin\StatsController;
use App\Http\Controllers\Admin\ProductAdminController;
use App\Http\Controllers\Admin\CategoryAdminController;
use App\Http\Controllers\Admin\OrderAdminController;
use App\Http\Controllers\Admin\UserAdminController;
use App\Http\Controllers\Admin\VendorAdminController;
use App\Http\Controllers\Admin\SliderAdminController;
use App\Http\Controllers\Admin\SettingAdminController;
use App\Http\Controllers\Admin\WholesaleAdminController;
use App\Http\Controllers\Admin\CouponAdminController;
use App\Http\Controllers\Admin\ReviewAdminController;
use App\Http\Controllers\Admin\ContactAdminController;
use App\Http\Controllers\Admin\UploadController;

Route::middleware(['auth:sanctum', 'admin'])->prefix('admin')->group(function () {
    // File upload
    Route::post('/upload',        [UploadController::class, 'upload']);
    Route::delete('/upload',      [UploadController::class, 'delete']);

    // Dashboard
    Route::get('/stats', [StatsController::class, 'index']);

    // Products
    Route::get('/products',          [ProductAdminController::class, 'index']);
    Route::get('/products/{id}',     [ProductAdminController::class, 'show']);
    Route::post('/products',         [ProductAdminController::class, 'store']);
    Route::put('/products/{id}',     [ProductAdminController::class, 'update']);
    Route::delete('/products/{id}',  [ProductAdminController::class, 'destroy']);

    // Categories
    Route::get('/categories',        [CategoryAdminController::class, 'index']);
    Route::post('/categories',       [CategoryAdminController::class, 'store']);
    Route::put('/categories/{id}',   [CategoryAdminController::class, 'update']);
    Route::delete('/categories/{id}',[CategoryAdminController::class, 'destroy']);

    // Orders
    Route::get('/orders',            [OrderAdminController::class, 'index']);
    Route::get('/orders/{id}',       [OrderAdminController::class, 'show']);
    Route::put('/orders/{id}',       [OrderAdminController::class, 'updateStatus']);

    // Users
    Route::get('/users',             [UserAdminController::class, 'index']);
    Route::get('/users/{id}',        [UserAdminController::class, 'show']);
    Route::put('/users/{id}/toggle-admin', [UserAdminController::class, 'toggleAdmin']);

    // Vendors
    Route::get('/vendors',           [VendorAdminController::class, 'index']);
    Route::post('/vendors',          [VendorAdminController::class, 'store']);
    Route::put('/vendors/{id}',      [VendorAdminController::class, 'update']);
    Route::delete('/vendors/{id}',   [VendorAdminController::class, 'destroy']);

    // Sliders
    Route::get('/sliders',           [SliderAdminController::class, 'indexSliders']);
    Route::post('/sliders',          [SliderAdminController::class, 'storeSlider']);
    Route::put('/sliders/{id}',      [SliderAdminController::class, 'updateSlider']);
    Route::delete('/sliders/{id}',   [SliderAdminController::class, 'destroySlider']);

    // Banners
    Route::get('/banners',           [SliderAdminController::class, 'indexBanners']);
    Route::post('/banners',          [SliderAdminController::class, 'storeBanner']);
    Route::put('/banners/{id}',      [SliderAdminController::class, 'updateBanner']);
    Route::delete('/banners/{id}',   [SliderAdminController::class, 'destroyBanner']);

    // Settings
    Route::get('/settings',          [SettingAdminController::class, 'index']);
    Route::put('/settings',          [SettingAdminController::class, 'update']);

    // Wholesale
    Route::get('/wholesale',         [WholesaleAdminController::class, 'index']);
    Route::put('/wholesale/{id}',    [WholesaleAdminController::class, 'updateStatus']);

    // Coupons
    Route::get('/coupons',           [CouponAdminController::class, 'index']);
    Route::post('/coupons',          [CouponAdminController::class, 'store']);
    Route::put('/coupons/{id}',      [CouponAdminController::class, 'update']);
    Route::delete('/coupons/{id}',   [CouponAdminController::class, 'destroy']);

    // Reviews
    Route::get('/reviews',                  [ReviewAdminController::class, 'index']);
    Route::put('/reviews/{id}/approve',     [ReviewAdminController::class, 'toggleApprove']);
    Route::delete('/reviews/{id}',          [ReviewAdminController::class, 'destroy']);

    // Contacts
    Route::get('/contacts',                 [ContactAdminController::class, 'index']);
    Route::put('/contacts/{id}/read',       [ContactAdminController::class, 'markRead']);

    // Newsletter
    Route::get('/newsletter',               [ContactAdminController::class, 'newsletter']);
});
