<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<style>
body { font-family: Arial, sans-serif; background: #f5f5f5; margin: 0; padding: 20px; }
.container { max-width: 600px; margin: 0 auto; background: #fff; border-radius: 8px; overflow: hidden; }
.header { background: #3BB77E; padding: 30px; text-align: center; }
.header h1 { color: #fff; margin: 0; }
.body { padding: 30px; }
.status-badge { display: inline-block; padding: 8px 16px; border-radius: 20px; font-weight: bold; background: #d4edda; color: #155724; }
.footer { background: #f5f5f5; padding: 20px; text-align: center; color: #888; font-size: 12px; }
</style>
</head>
<body>
<div class="container">
  <div class="header"><h1>Order Update</h1></div>
  <div class="body">
    <p>Your order status has been updated.</p>
    <h3>Order #{{ $order->order_number }}</h3>
    <p>New Status: <span class="status-badge">{{ ucfirst($status) }}</span></p>
    @if($status === 'shipped')
    <p>Your order is on its way! You'll receive it soon.</p>
    @elseif($status === 'delivered')
    <p>Your order has been delivered. Enjoy your purchase!</p>
    @elseif($status === 'cancelled')
    <p>Your order has been cancelled. If you have any questions, please contact us.</p>
    @endif
    <p><strong>Total:</strong> ${{ number_format($order->total, 2) }}</p>
  </div>
  <div class="footer">&copy; {{ date('Y') }} Kalses Store. All rights reserved.</div>
</div>
</body>
</html>
