<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<style>
body { font-family: Arial, sans-serif; background: #f5f5f5; margin: 0; padding: 20px; }
.container { max-width: 600px; margin: 0 auto; background: #fff; border-radius: 8px; overflow: hidden; }
.header { background: #3BB77E; padding: 30px; text-align: center; }
.header h1 { color: #fff; margin: 0; }
.body { padding: 30px; }
table { width: 100%; border-collapse: collapse; margin: 20px 0; }
th { background: #f5f5f5; padding: 10px; text-align: left; font-size: 13px; }
td { padding: 10px; border-bottom: 1px solid #eee; font-size: 13px; }
.total-row td { font-weight: bold; border-top: 2px solid #3BB77E; }
.footer { background: #f5f5f5; padding: 20px; text-align: center; color: #888; font-size: 12px; }
</style>
</head>
<body>
<div class="container">
  <div class="header"><h1>Order Confirmed!</h1></div>
  <div class="body">
    <p>Thank you for your order. We've received it and will begin processing shortly.</p>
    <h3>Order #{{ $order->order_number }}</h3>
    <p><strong>Status:</strong> {{ ucfirst($order->status) }}<br>
    <strong>Payment:</strong> {{ strtoupper($order->payment_method) }}</p>

    <h4>Items</h4>
    <table>
      <tr><th>Product</th><th>Qty</th><th>Price</th></tr>
      @foreach($order->items as $item)
      <tr>
        <td>{{ $item->product_name }}</td>
        <td>{{ $item->quantity }}</td>
        <td>${{ number_format($item->subtotal, 2) }}</td>
      </tr>
      @endforeach
      <tr><td colspan="2">Subtotal</td><td>${{ number_format($order->subtotal, 2) }}</td></tr>
      @if($order->discount > 0)
      <tr><td colspan="2">Discount</td><td>-${{ number_format($order->discount, 2) }}</td></tr>
      @endif
      <tr><td colspan="2">Tax</td><td>${{ number_format($order->tax, 2) }}</td></tr>
      <tr class="total-row"><td colspan="2">Total</td><td>${{ number_format($order->total, 2) }}</td></tr>
    </table>

    <h4>Shipping Address</h4>
    <p>{{ $order->shipping_name }}<br>
    {{ $order->shipping_address }}<br>
    {{ $order->shipping_city }}, {{ $order->shipping_state }} {{ $order->shipping_zip }}<br>
    {{ $order->shipping_country }}</p>
  </div>
  <div class="footer">&copy; {{ date('Y') }} Kalses Store. All rights reserved.</div>
</div>
</body>
</html>
