<?php
namespace Database\Seeders;

use App\Models\Vendor;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class VendorSeeder extends Seeder
{
    public function run()
    {
        $vendors = [
            [
                'store_name'      => 'TechZone Store',
                'description'     => 'Your premier destination for the latest tech gadgets and electronics.',
                'email'           => 'techzone@example.com',
                'phone'           => '+1-555-0101',
                'address'         => '123 Tech Ave, Silicon Valley, CA 94025',
                'rating'          => 4.8,
                'reviews_count'   => 234,
                'followers_count' => 1520,
                'products_count'  => 48,
                'is_verified'     => true,
            ],
            [
                'store_name'      => 'FashionHub',
                'description'     => 'Trendy clothing and accessories for the modern lifestyle.',
                'email'           => 'fashionhub@example.com',
                'phone'           => '+1-555-0102',
                'address'         => '456 Fashion Blvd, New York, NY 10001',
                'rating'          => 4.6,
                'reviews_count'   => 189,
                'followers_count' => 2340,
                'products_count'  => 120,
                'is_verified'     => true,
            ],
            [
                'store_name'      => 'HomeDecor Pro',
                'description'     => 'Beautiful furniture and home decor at affordable prices.',
                'email'           => 'homedecor@example.com',
                'phone'           => '+1-555-0103',
                'address'         => '789 Interior Lane, Chicago, IL 60601',
                'rating'          => 4.5,
                'reviews_count'   => 156,
                'followers_count' => 890,
                'products_count'  => 75,
                'is_verified'     => true,
            ],
            [
                'store_name'      => 'SportsMaster',
                'description'     => 'Professional sports equipment for every athlete.',
                'email'           => 'sportsmaster@example.com',
                'phone'           => '+1-555-0104',
                'address'         => '321 Sports Drive, Dallas, TX 75201',
                'rating'          => 4.7,
                'reviews_count'   => 98,
                'followers_count' => 670,
                'products_count'  => 62,
                'is_verified'     => false,
            ],
            [
                'store_name'      => 'GadgetWorld',
                'description'     => 'Innovative gadgets and smart home devices.',
                'email'           => 'gadgetworld@example.com',
                'phone'           => '+1-555-0105',
                'address'         => '555 Innovation Park, Seattle, WA 98101',
                'rating'          => 4.4,
                'reviews_count'   => 213,
                'followers_count' => 1100,
                'products_count'  => 88,
                'is_verified'     => true,
            ],
        ];

        foreach ($vendors as $v) {
            Vendor::create(array_merge($v, [
                'slug'      => Str::slug($v['store_name']),
                'is_active' => true,
            ]));
        }
    }
}
