<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    public function run()
    {
        // Admin account
        User::updateOrCreate(
            ['email' => 'admin@kalses.com'],
            [
                'name'     => 'Administrator',
                'password' => Hash::make('admin123'),
                'is_admin' => true,
            ]
        );

        // Demo customer account
        User::updateOrCreate(
            ['email' => 'customer@kalses.com'],
            [
                'name'     => 'Demo Customer',
                'password' => Hash::make('customer123'),
                'is_admin' => false,
                'phone'    => '+1-555-0100',
                'address'  => '123 Main Street',
                'city'     => 'New York',
                'state'    => 'NY',
                'zip'      => '10001',
                'country'  => 'US',
            ]
        );
    }
}
