<?php
namespace Database\Seeders;

use App\Models\Banner;
use App\Models\Slider;
use Illuminate\Database\Seeder;

class SliderSeeder extends Seeder
{
    public function run()
    {
        $sliders = [
            [
                'title'       => 'Latest iPhone 15 Pro Max',
                'subtitle'    => 'New Arrival 2024',
                'description' => 'Experience the future with titanium design and A17 Pro chip. Starting at $1,099',
                'image'       => 'https://via.placeholder.com/1200x600/333333/ffffff?text=iPhone+15+Pro+Max',
                'link'        => '/product/apple-iphone-15-pro-max-256gb',
                'button_text' => 'Shop Now',
                'sort_order'  => 1,
            ],
            [
                'title'       => 'Sony WH-1000XM5',
                'subtitle'    => 'Best in Class Noise Cancellation',
                'description' => 'Industry-leading noise cancellation. Now $299 — Save $100!',
                'image'       => 'https://via.placeholder.com/1200x600/1a1a2e/ffffff?text=Sony+WH-1000XM5',
                'link'        => '/product/sony-wh-1000xm5-noise-cancelling-headphones',
                'button_text' => 'Shop Now',
                'sort_order'  => 2,
            ],
            [
                'title'       => 'MacBook Pro M3 Pro',
                'subtitle'    => 'Pro Performance Unleashed',
                'description' => 'Mind-blowing performance for creative professionals. From $1,849',
                'image'       => 'https://via.placeholder.com/1200x600/0d0d0d/ffffff?text=MacBook+Pro+M3',
                'link'        => '/product/macbook-pro-14-m3-pro',
                'button_text' => 'Explore',
                'sort_order'  => 3,
            ],
        ];

        foreach ($sliders as $s) {
            Slider::create(array_merge($s, ['is_active' => true]));
        }

        $banners = [
            [
                'title'      => 'Electronics Sale',
                'image'      => 'https://via.placeholder.com/400x300/e84393/ffffff?text=Electronics+Sale',
                'link'       => '/shop?category=1',
                'position'   => 'home',
                'sort_order' => 1,
            ],
            [
                'title'      => 'Fashion Sale Up to 50% Off',
                'image'      => 'https://via.placeholder.com/400x300/8B5CF6/ffffff?text=Fashion+Sale',
                'link'       => '/shop?category=9',
                'position'   => 'home',
                'sort_order' => 2,
            ],
            [
                'title'      => 'Gaming Zone',
                'image'      => 'https://via.placeholder.com/400x300/10B981/ffffff?text=Gaming+Zone',
                'link'       => '/shop?category=7',
                'position'   => 'home',
                'sort_order' => 3,
            ],
        ];

        foreach ($banners as $b) {
            Banner::create(array_merge($b, ['is_active' => true]));
        }
    }
}
