<?php
namespace Database\Seeders;

use App\Models\Setting;
use Illuminate\Database\Seeder;

class SettingSeeder extends Seeder
{
    public function run()
    {
        $settings = [
            ['key' => 'site_name',                'value' => 'Kalses',                          'group' => 'general'],
            ['key' => 'site_tagline',             'value' => 'Your One-Stop Online Shop',        'group' => 'general'],
            ['key' => 'contact_email',            'value' => 'info@kalses.com',                  'group' => 'general'],
            ['key' => 'contact_phone',            'value' => '1900-888',                         'group' => 'general'],
            ['key' => 'contact_address',          'value' => '123 Main Street, City, Country',   'group' => 'general'],
            ['key' => 'currency',                 'value' => 'USD',                              'group' => 'general'],
            ['key' => 'currency_symbol',          'value' => '$',                                'group' => 'general'],
            ['key' => 'tax_rate',                 'value' => '8',                                'group' => 'general'],
            ['key' => 'shipping_free_threshold',  'value' => '100',                              'group' => 'shipping'],
            ['key' => 'facebook_url',             'value' => '#',                                'group' => 'social'],
            ['key' => 'instagram_url',            'value' => '#',                                'group' => 'social'],
            ['key' => 'twitter_url',              'value' => '#',                                'group' => 'social'],
        ];

        foreach ($settings as $s) {
            Setting::updateOrCreate(['key' => $s['key']], $s);
        }
    }
}
