<?php
namespace Database\Seeders;

use App\Models\Product;
use App\Models\ProductImage;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class ProductSeeder extends Seeder
{
    public function run()
    {
        $products = [
            [
                'category_id' => 1, 'vendor_id' => 1,
                'name' => 'Apple iPhone 15 Pro Max 256GB',
                'price' => 1199.00, 'sale_price' => 1099.00,
                'stock' => 45, 'sku' => 'APPL-IP15PM-256',
                'brand' => 'Apple', 'rating' => 4.9, 'reviews_count' => 156,
                'is_featured' => true, 'is_deal' => true, 'is_best_seller' => true,
                'short_description' => 'The most powerful iPhone ever with A17 Pro chip and titanium design.',
                'description' => '<p>The iPhone 15 Pro Max features the groundbreaking A17 Pro chip, a titanium design, and an advanced camera system with 5x optical zoom.</p><ul><li>A17 Pro chip</li><li>Titanium frame</li><li>48MP main camera</li><li>5x optical zoom</li></ul>',
                'attributes' => ['Storage' => '256GB', 'Color' => 'Natural Titanium', 'Display' => '6.7" Super Retina XDR'],
            ],
            [
                'category_id' => 2, 'vendor_id' => 1,
                'name' => 'MacBook Pro 14" M3 Pro',
                'price' => 1999.00, 'sale_price' => 1849.00,
                'stock' => 20, 'sku' => 'APPL-MBP14-M3',
                'brand' => 'Apple', 'rating' => 4.8, 'reviews_count' => 89,
                'is_featured' => true, 'is_deal' => false, 'is_best_seller' => true,
                'short_description' => 'M3 Pro chip. Mind-blowing performance for professionals.',
                'description' => '<p>MacBook Pro with M3 Pro chip delivers extraordinary performance with up to 18-hour battery life and the stunning Liquid Retina XDR display.</p>',
                'attributes' => ['Chip' => 'M3 Pro', 'RAM' => '18GB', 'Storage' => '512GB SSD', 'Display' => '14.2" Liquid Retina XDR'],
            ],
            [
                'category_id' => 1, 'vendor_id' => 5,
                'name' => 'Samsung Galaxy S24 Ultra 256GB',
                'price' => 1299.00, 'sale_price' => 1149.00,
                'stock' => 35, 'sku' => 'SAMS-S24U-256',
                'brand' => 'Samsung', 'rating' => 4.7, 'reviews_count' => 203,
                'is_featured' => true, 'is_deal' => true,
                'short_description' => 'Galaxy AI. The ultimate Galaxy experience with built-in S Pen.',
                'description' => '<p>Samsung Galaxy S24 Ultra with Galaxy AI transforms your smartphone. Features built-in S Pen, 200MP camera, and Snapdragon 8 Gen 3.</p>',
                'attributes' => ['Storage' => '256GB', 'RAM' => '12GB', 'Camera' => '200MP', 'Display' => '6.8" QHD+'],
            ],
            [
                'category_id' => 4, 'vendor_id' => 5,
                'name' => 'Sony WH-1000XM5 Noise Cancelling Headphones',
                'price' => 399.00, 'sale_price' => 299.00,
                'stock' => 60, 'sku' => 'SONY-WH1000XM5',
                'brand' => 'Sony', 'rating' => 4.9, 'reviews_count' => 445,
                'is_featured' => true, 'is_deal' => true, 'is_best_seller' => true,
                'short_description' => 'Industry-leading noise cancellation with 30-hour battery life.',
                'description' => '<p>Experience unrivaled noise cancellation with Sony WH-1000XM5. Eight microphones, two processors, 30-hour battery with Quick Charge.</p>',
                'attributes' => ['Driver' => '30mm', 'Battery' => '30 hours', 'Connectivity' => 'Bluetooth 5.2'],
            ],
            [
                'category_id' => 7, 'vendor_id' => 1,
                'name' => 'PlayStation 5 Console',
                'price' => 499.00, 'sale_price' => null,
                'stock' => 15, 'sku' => 'SONY-PS5',
                'brand' => 'Sony', 'rating' => 4.9, 'reviews_count' => 867,
                'is_featured' => true, 'is_deal' => false, 'is_best_seller' => true,
                'short_description' => 'Next-gen gaming with ultra-high speed SSD and DualSense controller.',
                'description' => '<p>PlayStation 5 offers incredible loading times, deeper immersion through haptic feedback, adaptive triggers, and 3D Audio.</p>',
                'attributes' => ['CPU' => 'AMD Zen 2', 'GPU' => 'AMD RDNA 2', 'Storage' => '825GB SSD', 'Resolution' => '4K 120fps'],
            ],
            [
                'category_id' => 6, 'vendor_id' => 5,
                'name' => 'LG 55" 4K OLED Smart TV',
                'price' => 1499.00, 'sale_price' => 1199.00,
                'stock' => 12, 'sku' => 'LG-55-OLED',
                'brand' => 'LG', 'rating' => 4.7, 'reviews_count' => 123,
                'is_featured' => true, 'is_deal' => true,
                'short_description' => 'Perfect blacks and infinite contrast with OLED technology.',
                'description' => '<p>LG OLED TV with α9 AI Processor 4K Gen6. Self-lit pixels deliver perfect blacks and rich, vibrant colors.</p>',
                'attributes' => ['Size' => '55 inches', 'Resolution' => '4K 3840x2160', 'HDR' => 'Dolby Vision', 'Smart TV' => 'webOS 23'],
            ],
            [
                'category_id' => 2, 'vendor_id' => 5,
                'name' => 'Dell XPS 15 Laptop i9',
                'price' => 2299.00, 'sale_price' => 1999.00,
                'stock' => 8, 'sku' => 'DELL-XPS15-I9',
                'brand' => 'Dell', 'rating' => 4.6, 'reviews_count' => 67,
                'is_featured' => false, 'is_deal' => true, 'is_new' => true,
                'short_description' => "The world's most popular 15\" high-performance laptop.",
                'description' => '<p>Dell XPS 15 with Intel Core i9 processor and NVIDIA GeForce RTX 4070 GPU delivers exceptional performance for creative professionals.</p>',
                'attributes' => ['CPU' => 'Intel Core i9-13900H', 'RAM' => '32GB DDR5', 'Storage' => '1TB NVMe SSD', 'GPU' => 'NVIDIA RTX 4070'],
            ],
            [
                'category_id' => 5, 'vendor_id' => 1,
                'name' => 'Canon EOS R6 Mark II Mirrorless Camera',
                'price' => 2499.00, 'sale_price' => 2199.00,
                'stock' => 10, 'sku' => 'CANON-EOSR6M2',
                'brand' => 'Canon', 'rating' => 4.8, 'reviews_count' => 45,
                'is_featured' => true, 'is_new' => true,
                'short_description' => 'A powerhouse hybrid mirrorless for stills and video.',
                'description' => '<p>Canon EOS R6 Mark II features a 40MP full-frame sensor with 6K RAW video capabilities and advanced AF with subject detection.</p>',
                'attributes' => ['Sensor' => '40.2MP Full Frame', 'Video' => '6K RAW', 'Burst' => '40fps'],
            ],
            [
                'category_id' => 10, 'vendor_id' => 2,
                'name' => 'Nike Air Max 270 Sneakers',
                'price' => 150.00, 'sale_price' => 119.00,
                'stock' => 100, 'sku' => 'NIKE-AM270',
                'brand' => 'Nike', 'rating' => 4.5, 'reviews_count' => 289,
                'is_featured' => false, 'is_best_seller' => true,
                'short_description' => 'The first lifestyle Air Max shoe with a heel unit for all-day comfort.',
                'description' => '<p>Nike Air Max 270 features the biggest heel Air unit yet for a super-soft ride that lets you take on the city in style and comfort.</p>',
                'attributes' => ['Material' => 'Mesh', 'Sole' => 'Rubber', 'Closure' => 'Lace-up'],
            ],
            [
                'category_id' => 10, 'vendor_id' => 2,
                'name' => 'Adidas Ultraboost 23 Running Shoes',
                'price' => 190.00, 'sale_price' => 149.00,
                'stock' => 75, 'sku' => 'ADID-UB23',
                'brand' => 'Adidas', 'rating' => 4.7, 'reviews_count' => 178,
                'is_featured' => true, 'is_deal' => true,
                'short_description' => 'Energy return like never before with Boost midsole.',
                'description' => '<p>Adidas Ultraboost 23 delivers incredible energy return with Boost technology and a Primeknit+ upper for a snug, adaptive fit.</p>',
                'attributes' => ['Upper' => 'Primeknit+', 'Midsole' => 'Boost', 'Outsole' => 'Continental Rubber'],
            ],
            [
                'category_id' => 11, 'vendor_id' => 4,
                'name' => 'Hydro Flask 32oz Wide Mouth Water Bottle',
                'price' => 49.95, 'sale_price' => null,
                'stock' => 200, 'sku' => 'HF-32WM',
                'brand' => 'Hydro Flask', 'rating' => 4.8, 'reviews_count' => 512,
                'is_featured' => false, 'is_best_seller' => true,
                'short_description' => 'Keeps drinks cold 24 hours or hot 12 hours.',
                'description' => '<p>Hydro Flask 32oz Wide Mouth is made from professional-grade 18/8 stainless steel with TempShield double-wall vacuum insulation.</p>',
                'attributes' => ['Capacity' => '32 oz', 'Material' => '18/8 Stainless Steel', 'Waterproof' => 'Yes'],
            ],
            [
                'category_id' => 14, 'vendor_id' => 2,
                'name' => 'Dyson V15 Detect Vacuum Cleaner',
                'price' => 749.00, 'sale_price' => 649.00,
                'stock' => 25, 'sku' => 'DYSON-V15',
                'brand' => 'Dyson', 'rating' => 4.7, 'reviews_count' => 134,
                'is_featured' => true, 'is_new' => true,
                'short_description' => "Laser reveals microscopic dust you'd otherwise miss.",
                'description' => '<p>Dyson V15 Detect features a laser that illuminates microscopic dust and an LCD screen showing what your vacuum has picked up.</p>',
                'attributes' => ['Suction' => '230AW', 'Battery' => '60 min', 'Filtration' => 'HEPA'],
            ],
            [
                'category_id' => 15, 'vendor_id' => 3,
                'name' => 'IKEA KALLAX Shelf Unit 4x2',
                'price' => 129.00, 'sale_price' => null,
                'stock' => 40, 'sku' => 'IKEA-KALLAX-4X2',
                'brand' => 'IKEA', 'rating' => 4.3, 'reviews_count' => 567,
                'is_featured' => false, 'is_best_seller' => true,
                'short_description' => 'Perfect for storing and displaying your belongings.',
                'description' => '<p>KALLAX shelf unit is a versatile storage solution. Use it as a room divider or mount on the wall. Compatible with KALLAX inserts.</p>',
                'attributes' => ['Dimensions' => '147x147 cm', 'Material' => 'Particleboard', 'Compartments' => '8'],
            ],
            [
                'category_id' => 12, 'vendor_id' => 3,
                'name' => 'Kindle Paperwhite 16GB E-Reader',
                'price' => 139.99, 'sale_price' => 119.99,
                'stock' => 80, 'sku' => 'AMZN-KPW5',
                'brand' => 'Amazon', 'rating' => 4.6, 'reviews_count' => 892,
                'is_featured' => false, 'is_deal' => true,
                'short_description' => '6.8" display with adjustable warm light and waterproof design.',
                'description' => '<p>Kindle Paperwhite features a 6.8" 300 ppi glare-free display, adjustable warm light, and 10-week battery life. IPX8 waterproof.</p>',
                'attributes' => ['Display' => '6.8" 300 ppi', 'Storage' => '16GB', 'Battery' => '10 weeks', 'Waterproof' => 'IPX8'],
            ],
            [
                'category_id' => 1, 'vendor_id' => 5,
                'name' => 'Google Nest Hub 2nd Gen Smart Display',
                'price' => 99.99, 'sale_price' => 79.99,
                'stock' => 55, 'sku' => 'GOOG-NH2',
                'brand' => 'Google', 'rating' => 4.4, 'reviews_count' => 234,
                'is_featured' => false, 'is_new' => true, 'is_deal' => true,
                'short_description' => 'Smart home hub with sleep tracking and Google Assistant.',
                'description' => '<p>Google Nest Hub 2nd Gen features a 7" display, sleep sensing, and Google Assistant to help manage your smart home hands-free.</p>',
                'attributes' => ['Display' => '7" LCD', 'Connectivity' => 'Wi-Fi, Bluetooth', 'Color' => 'Chalk'],
            ],
            [
                'category_id' => 8, 'vendor_id' => 3,
                'name' => 'Instant Pot Duo 7-in-1 Electric Pressure Cooker',
                'price' => 99.95, 'sale_price' => 79.95,
                'stock' => 90, 'sku' => 'IP-DUO-7QT',
                'brand' => 'Instant Pot', 'rating' => 4.7, 'reviews_count' => 1245,
                'is_featured' => false, 'is_best_seller' => true,
                'short_description' => '7-in-1 multi-use: pressure cooker, slow cooker, rice cooker and more.',
                'description' => '<p>Instant Pot Duo 7-in-1 replaces 7 kitchen appliances. Cooks up to 70% faster than traditional methods.</p>',
                'attributes' => ['Capacity' => '7 Quart', 'Functions' => '7-in-1', 'Programs' => '13 built-in'],
            ],
            [
                'category_id' => 13, 'vendor_id' => 3,
                'name' => 'LEGO Technic Bugatti Bolide 42151',
                'price' => 59.99, 'sale_price' => null,
                'stock' => 35, 'sku' => 'LEGO-42151',
                'brand' => 'LEGO', 'rating' => 4.8, 'reviews_count' => 189,
                'is_featured' => false, 'is_new' => true,
                'short_description' => '905-piece Bugatti Bolide model for ages 10+.',
                'description' => '<p>Build the iconic Bugatti Bolide with 905 LEGO Technic pieces. Features W16 engine with moving pistons, steerable front wheels.</p>',
                'attributes' => ['Pieces' => '905', 'Age' => '10+', 'Theme' => 'Technic'],
            ],
            [
                'category_id' => 3, 'vendor_id' => 1,
                'name' => 'iPad Pro 12.9" M2 Chip 256GB Wi-Fi',
                'price' => 1099.00, 'sale_price' => 999.00,
                'stock' => 22, 'sku' => 'APPL-IPADPRO-M2',
                'brand' => 'Apple', 'rating' => 4.9, 'reviews_count' => 98,
                'is_featured' => true, 'is_deal' => true, 'is_new' => true,
                'short_description' => 'Supercharged by M2. The ultimate iPad experience.',
                'description' => '<p>iPad Pro with M2 chip features a stunning Liquid Retina XDR display, ProMotion technology up to 120Hz, and USB-C with Thunderbolt.</p>',
                'attributes' => ['Chip' => 'Apple M2', 'Display' => '12.9" Liquid Retina XDR', 'Storage' => '256GB'],
            ],
            [
                'category_id' => 4, 'vendor_id' => 1,
                'name' => 'JBL Charge 5 Portable Bluetooth Speaker',
                'price' => 179.95, 'sale_price' => 149.95,
                'stock' => 65, 'sku' => 'JBL-CHARGE5',
                'brand' => 'JBL', 'rating' => 4.6, 'reviews_count' => 345,
                'is_featured' => false, 'is_best_seller' => true, 'is_deal' => true,
                'short_description' => 'Waterproof Bluetooth speaker with 20-hour battery.',
                'description' => '<p>JBL Charge 5 delivers bold JBL Original Pro Sound with powerful bass, IP67 waterproof design, and 20-hour battery life.</p>',
                'attributes' => ['Power' => '30W', 'Battery' => '20 hours', 'Waterproof' => 'IP67', 'Connectivity' => 'Bluetooth 5.1'],
            ],
            [
                'category_id' => 11, 'vendor_id' => 4,
                'name' => 'Yoga Mat Non-Slip 6mm Thick',
                'price' => 39.99, 'sale_price' => 29.99,
                'stock' => 150, 'sku' => 'YM-6MM-NBK',
                'brand' => 'FitPro', 'rating' => 4.5, 'reviews_count' => 456,
                'is_featured' => false,
                'short_description' => 'Premium non-slip yoga mat with carrying strap.',
                'description' => '<p>FitPro yoga mat features superior grip on both sides, eco-friendly TPE material, and 6mm thickness for joint protection.</p>',
                'attributes' => ['Thickness' => '6mm', 'Material' => 'TPE', 'Dimensions' => '183x61 cm'],
            ],
        ];

        foreach ($products as $i => $data) {
            $product = Product::create([
                'category_id'       => $data['category_id'],
                'vendor_id'         => $data['vendor_id'],
                'name'              => $data['name'],
                'slug'              => Str::slug($data['name']),
                'short_description' => $data['short_description'],
                'description'       => $data['description'],
                'price'             => $data['price'],
                'sale_price'        => $data['sale_price'] ?? null,
                'stock'             => $data['stock'],
                'sku'               => $data['sku'],
                'brand'             => $data['brand'],
                'rating'            => $data['rating'],
                'reviews_count'     => $data['reviews_count'],
                'sales_count'       => rand(10, 500),
                'is_featured'       => $data['is_featured'] ?? false,
                'is_deal'           => $data['is_deal'] ?? false,
                'is_new'            => $data['is_new'] ?? true,
                'is_best_seller'    => $data['is_best_seller'] ?? false,
                'is_active'         => true,
                'attributes'        => $data['attributes'] ?? null,
                'deal_ends_at'      => ($data['is_deal'] ?? false) ? now()->addDays(rand(3, 14)) : null,
            ]);

            // Primary image
            ProductImage::create([
                'product_id' => $product->id,
                'url'        => 'https://placehold.co/600x600/eeeeee/666666?text=' . urlencode($product->name),
                'is_primary'  => true,
                'sort_order' => 0,
            ]);
            // Additional images
            for ($j = 1; $j <= 2; $j++) {
                ProductImage::create([
                    'product_id' => $product->id,
                    'url'        => 'https://placehold.co/600x600/dddddd/888888?text=View+' . $j,
                    'is_primary'  => false,
                    'sort_order' => $j,
                ]);
            }
        }
    }
}
