<?php

namespace Database\Seeders;

use App\Models\Order;
use App\Models\OrderItem;
use App\Models\Product;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class OrderSeeder extends Seeder
{
    public function run()
    {
        $customer = User::where('email', 'customer@kalses.com')->first();
        if (!$customer) return;

        $products = Product::with('primaryImage')->take(10)->get();
        if ($products->isEmpty()) return;

        $orders = [
            ['status' => 'delivered', 'payment_status' => 'paid',    'daysAgo' => 1],
            ['status' => 'delivered', 'payment_status' => 'paid',    'daysAgo' => 2],
            ['status' => 'shipped',   'payment_status' => 'paid',    'daysAgo' => 3],
            ['status' => 'processing','payment_status' => 'paid',    'daysAgo' => 4],
            ['status' => 'delivered', 'payment_status' => 'paid',    'daysAgo' => 5],
            ['status' => 'delivered', 'payment_status' => 'paid',    'daysAgo' => 5],
            ['status' => 'pending',   'payment_status' => 'pending', 'daysAgo' => 6],
            ['status' => 'delivered', 'payment_status' => 'paid',    'daysAgo' => 7],
            ['status' => 'cancelled', 'payment_status' => 'failed',  'daysAgo' => 8],
            ['status' => 'delivered', 'payment_status' => 'paid',    'daysAgo' => 10],
        ];

        foreach ($orders as $orderData) {
            $product  = $products->random();
            $price    = (float) $product->price;
            $salePrice = $product->sale_price ? (float) $product->sale_price : null;
            $effectivePrice = $salePrice ?? $price;
            $qty      = rand(1, 3);
            $subtotal = round($effectivePrice * $qty, 2);
            $tax      = round($subtotal * 0.08, 2);
            $total    = round($subtotal + $tax, 2);

            $order = Order::create([
                'user_id'          => $customer->id,
                'order_number'     => 'ORD-' . strtoupper(Str::random(10)),
                'status'           => $orderData['status'],
                'subtotal'         => $subtotal,
                'discount'         => 0,
                'shipping'         => 0,
                'tax'              => $tax,
                'total'            => $total,
                'payment_method'   => 'cod',
                'payment_status'   => $orderData['payment_status'],
                'shipping_name'    => $customer->name,
                'shipping_email'   => $customer->email,
                'shipping_phone'   => '+1-555-0100',
                'shipping_address' => '123 Main Street',
                'shipping_city'    => 'New York',
                'shipping_state'   => 'NY',
                'shipping_zip'     => '10001',
                'shipping_country' => 'US',
                'is_wholesale'     => false,
                'created_at'       => now()->subDays($orderData['daysAgo']),
                'updated_at'       => now()->subDays($orderData['daysAgo']),
            ]);

            OrderItem::create([
                'order_id'      => $order->id,
                'product_id'    => $product->id,
                'product_name'  => $product->name,
                'product_image' => $product->primaryImage?->url,
                'price'         => $price,
                'sale_price'    => $salePrice,
                'quantity'      => $qty,
                'subtotal'      => $subtotal,
            ]);
        }
    }
}
