<?php
namespace Database\Seeders;

use App\Models\Coupon;
use Illuminate\Database\Seeder;

class CouponSeeder extends Seeder
{
    public function run()
    {
        $coupons = [
            [
                'code'        => 'WELCOME10',
                'type'        => 'percentage',
                'value'       => 10,
                'min_order'   => 50,
                'max_discount' => 50,
                'usage_limit' => 1000,
                'expires_at'  => now()->addYear(),
            ],
            [
                'code'        => 'SAVE20',
                'type'        => 'percentage',
                'value'       => 20,
                'min_order'   => 100,
                'max_discount' => 100,
                'usage_limit' => 500,
                'expires_at'  => now()->addMonths(6),
            ],
            [
                'code'        => 'FLAT15',
                'type'        => 'fixed',
                'value'       => 15,
                'min_order'   => 75,
                'usage_limit' => null,
                'expires_at'  => now()->addMonths(3),
            ],
            [
                'code'        => 'TECH30',
                'type'        => 'percentage',
                'value'       => 30,
                'min_order'   => 500,
                'max_discount' => 200,
                'usage_limit' => 200,
                'expires_at'  => now()->addMonths(2),
            ],
        ];

        foreach ($coupons as $c) {
            Coupon::create(array_merge($c, ['is_active' => true]));
        }
    }
}
