<?php
namespace Database\Seeders;

use App\Models\Category;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class CategorySeeder extends Seeder
{
    public function run()
    {
        $categories = [
            ['name' => 'Electronics',          'description' => 'Electronic devices and gadgets'],
            ['name' => 'Computers & Laptops',   'description' => 'Computers, laptops and accessories'],
            ['name' => 'Smartphones & Tablets', 'description' => 'Mobile phones and tablets'],
            ['name' => 'Audio & Headphones',    'description' => 'Headphones, speakers and audio gear'],
            ['name' => 'Cameras',               'description' => 'Digital cameras and photography equipment'],
            ['name' => 'TV & Displays',         'description' => 'Televisions and monitors'],
            ['name' => 'Gaming',                'description' => 'Gaming consoles, games and accessories'],
            ['name' => 'Home Appliances',       'description' => 'Kitchen and home appliances'],
            ['name' => 'Clothing & Apparel',    'description' => 'Men and women clothing'],
            ['name' => 'Shoes & Footwear',      'description' => 'Shoes, sneakers and boots'],
            ['name' => 'Sports & Outdoors',     'description' => 'Sports equipment and outdoor gear'],
            ['name' => 'Books & Media',         'description' => 'Books, music and movies'],
            ['name' => 'Toys & Kids',           'description' => 'Toys and products for children'],
            ['name' => 'Health & Beauty',       'description' => 'Health, beauty and personal care'],
            ['name' => 'Furniture',             'description' => 'Home and office furniture'],
        ];

        foreach ($categories as $i => $cat) {
            Category::create([
                'name'        => $cat['name'],
                'slug'        => Str::slug($cat['name']),
                'description' => $cat['description'],
                'sort_order'  => $i,
                'is_active'   => true,
            ]);
        }
    }
}
