<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Vendor extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id', 'store_name', 'slug', 'description', 'logo', 'banner',
        'email', 'phone', 'address', 'website', 'rating', 'reviews_count',
        'followers_count', 'products_count', 'is_verified', 'is_active',
    ];
    protected $casts = ['is_verified' => 'boolean', 'is_active' => 'boolean'];

    public function products() { return $this->hasMany(Product::class); }
    public function user() { return $this->belongsTo(User::class); }
}
