<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model
{
    use HasFactory, SoftDeletes;
    protected $fillable = [
        'category_id', 'vendor_id', 'name', 'slug', 'short_description',
        'description', 'price', 'sale_price', 'stock', 'sku', 'brand',
        'weight', 'attributes', 'rating', 'reviews_count', 'sales_count',
        'is_featured', 'is_deal', 'is_new', 'is_best_seller', 'is_active', 'deal_ends_at',
    ];
    protected $casts = [
        'attributes' => 'array',
        'is_featured' => 'boolean',
        'is_deal' => 'boolean',
        'is_new' => 'boolean',
        'is_best_seller' => 'boolean',
        'is_active' => 'boolean',
        'deal_ends_at' => 'datetime',
    ];

    public function category() { return $this->belongsTo(Category::class); }
    public function vendor() { return $this->belongsTo(Vendor::class); }
    public function images() { return $this->hasMany(ProductImage::class)->orderBy('sort_order'); }
    public function primaryImage() { return $this->hasOne(ProductImage::class)->where('is_primary', true); }
    public function reviews() { return $this->hasMany(Review::class)->where('is_approved', true); }
    public function orderItems() { return $this->hasMany(OrderItem::class); }
    public function cartItems() { return $this->hasMany(CartItem::class); }
    public function wishlistItems() { return $this->hasMany(WishlistItem::class); }
}
