<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Order extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id', 'order_number', 'status', 'subtotal', 'discount', 'shipping',
        'tax', 'total', 'coupon_code', 'payment_method', 'payment_status',
        'payment_reference', 'shipping_name', 'shipping_email', 'shipping_phone',
        'shipping_address', 'shipping_city', 'shipping_state', 'shipping_zip',
        'shipping_country', 'notes', 'is_wholesale',
    ];
    protected $casts = ['is_wholesale' => 'boolean'];

    public function user() { return $this->belongsTo(User::class); }
    public function items() { return $this->hasMany(OrderItem::class); }
}
