<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\WishlistItem;
use Illuminate\Http\Request;

class WishlistController extends Controller
{
    public function index(Request $request)
    {
        $items = WishlistItem::with(['product.primaryImage', 'product.images', 'product.category', 'product.vendor'])
            ->where('user_id', $request->user()->id)
            ->get();
        return response()->json($items);
    }

    public function store(Request $request)
    {
        $data = $request->validate(['product_id' => 'required|exists:products,id']);
        $item = WishlistItem::firstOrCreate([
            'user_id'    => $request->user()->id,
            'product_id' => $data['product_id'],
        ]);
        return response()->json($item->load('product.primaryImage'), 201);
    }

    public function destroy(Request $request, $productId)
    {
        WishlistItem::where('user_id', $request->user()->id)
            ->where('product_id', $productId)
            ->delete();
        return response()->json(['message' => 'Removed']);
    }
}
