<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Models\WholesaleApplication;
use Illuminate\Http\Request;

class WholesaleController extends Controller
{
    public function apply(Request $request)
    {
        $user = $request->user();
        if ($user->wholesaleApplication) {
            return response()->json([
                'message'     => 'Application already submitted',
                'application' => $user->wholesaleApplication,
            ]);
        }
        $data = $request->validate([
            'business_name'  => 'required|string',
            'contact_name'   => 'required|string',
            'email'          => 'required|email',
            'phone'          => 'required|string',
            'address'        => 'nullable|string',
            'city'           => 'nullable|string',
            'state'          => 'nullable|string',
            'zip'            => 'nullable|string',
            'country'        => 'nullable|string',
            'business_type'  => 'nullable|string',
            'tax_id'         => 'nullable|string',
            'annual_revenue' => 'nullable|string',
            'notes'          => 'nullable|string',
        ]);
        $app = WholesaleApplication::create(array_merge($data, ['user_id' => $user->id]));
        return response()->json($app, 201);
    }

    public function status(Request $request)
    {
        $app = $request->user()->wholesaleApplication;
        if (!$app) {
            return response()->json(['status' => null, 'application' => null]);
        }
        return response()->json(['status' => $app->status, 'application' => $app]);
    }

    public function orders(Request $request)
    {
        $orders = Order::with('items')
            ->where('user_id', $request->user()->id)
            ->where('is_wholesale', true)
            ->orderByDesc('created_at')
            ->paginate(10);
        return response()->json($orders);
    }
}
