<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Vendor;
use Illuminate\Http\Request;

class VendorController extends Controller
{
    public function index(Request $request)
    {
        $query = Vendor::where('is_active', true);
        if ($request->search) {
            $q = $request->search;
            $query->where('store_name', 'like', "%$q%");
        }
        match ($request->sort) {
            'rating'   => $query->orderByDesc('rating'),
            'products' => $query->orderByDesc('products_count'),
            default    => $query->orderByDesc('created_at'),
        };
        $perPage = min((int)($request->per_page ?? 12), 48);
        return response()->json($query->paginate($perPage));
    }

    public function show($id)
    {
        $vendor = Vendor::where('is_active', true)->findOrFail($id);
        return response()->json($vendor);
    }
}
