<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Banner;
use App\Models\Setting;
use App\Models\Slider;

class SettingController extends Controller
{
    public function settings()
    {
        $settings = Setting::all()->pluck('value', 'key');
        $decoded = $settings->map(function ($val) {
            $json = json_decode($val, true);
            return $json !== null ? $json : $val;
        });
        return response()->json($decoded);
    }

    public function sliders()
    {
        $sliders = Slider::where('is_active', true)->orderBy('sort_order')->get();
        return response()->json($sliders);
    }

    public function banners()
    {
        $banners = Banner::where('is_active', true)->orderBy('sort_order')->get();
        return response()->json($banners);
    }
}
