<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Newsletter;
use Illuminate\Http\Request;

class NewsletterController extends Controller
{
    public function subscribe(Request $request)
    {
        $data = $request->validate(['email' => 'required|email']);
        Newsletter::firstOrCreate(
            ['email' => $data['email']],
            ['is_active' => true]
        );
        return response()->json(['message' => 'Subscribed successfully']);
    }
}
