<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Coupon;
use Illuminate\Http\Request;

class CouponController extends Controller
{
    public function apply(Request $request)
    {
        $data   = $request->validate(['code' => 'required|string']);
        $coupon = Coupon::where('code', strtoupper($data['code']))->first();
        if (!$coupon) {
            return response()->json(['message' => 'Invalid coupon code'], 422);
        }
        $subtotal = (float)($request->subtotal ?? 0);
        if (!$coupon->isValid($subtotal)) {
            return response()->json(['message' => 'Coupon is expired or not applicable'], 422);
        }
        $discount = $coupon->calculateDiscount($subtotal);
        return response()->json([
            'code'     => $coupon->code,
            'type'     => $coupon->type,
            'value'    => $coupon->value,
            'discount' => $discount,
            'message'  => "Coupon applied! You save \$$discount",
        ]);
    }

    public function remove()
    {
        return response()->json(['message' => 'Coupon removed']);
    }
}
