<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Contact;
use Illuminate\Http\Request;

class ContactController extends Controller
{
    public function store(Request $request)
    {
        $data = $request->validate([
            'name'    => 'required|string|max:255',
            'email'   => 'required|email',
            'phone'   => 'nullable|string',
            'subject' => 'required|string|max:255',
            'message' => 'required|string',
        ]);
        Contact::create($data);
        return response()->json(['message' => 'Message sent successfully']);
    }
}
