<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\CompareItem;
use Illuminate\Http\Request;

class CompareController extends Controller
{
    public function index(Request $request)
    {
        $items = CompareItem::with(['product.primaryImage', 'product.images', 'product.category', 'product.vendor'])
            ->where('user_id', $request->user()->id)
            ->get();
        return response()->json($items);
    }

    public function store(Request $request)
    {
        $data  = $request->validate(['product_id' => 'required|exists:products,id']);
        $count = CompareItem::where('user_id', $request->user()->id)->count();
        if ($count >= 4) {
            return response()->json(['message' => 'Maximum 4 items in compare'], 422);
        }
        $item = CompareItem::firstOrCreate([
            'user_id'    => $request->user()->id,
            'product_id' => $data['product_id'],
        ]);
        return response()->json($item->load('product.primaryImage'), 201);
    }

    public function destroy(Request $request, $productId)
    {
        CompareItem::where('user_id', $request->user()->id)
            ->where('product_id', $productId)
            ->delete();
        return response()->json(['message' => 'Removed']);
    }

    public function clear(Request $request)
    {
        CompareItem::where('user_id', $request->user()->id)->delete();
        return response()->json(['message' => 'Cleared']);
    }
}
