<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\WholesaleApplication;
use App\Models\User;
use Illuminate\Http\Request;

class WholesaleAdminController extends Controller
{
    public function index(Request $request)
    {
        $query = WholesaleApplication::with('user:id,name,email');

        if ($status = $request->status) {
            $query->where('status', $status);
        }

        return response()->json($query->orderByDesc('created_at')->paginate(20));
    }

    public function updateStatus(Request $request, $id)
    {
        $app = WholesaleApplication::with('user')->findOrFail($id);

        $data = $request->validate([
            'status' => 'required|in:approved,rejected,pending',
        ]);

        $app->update($data);

        // Update user's wholesale flag
        if ($app->user) {
            $app->user->update([
                'is_wholesale' => $data['status'] === 'approved',
            ]);
        }

        return response()->json($app);
    }
}
