<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Vendor;
use Illuminate\Http\Request;

class VendorAdminController extends Controller
{
    public function index(Request $request)
    {
        $query = Vendor::withCount('products');

        if ($s = $request->search) {
            $query->where('store_name', 'like', "%$s%")
                  ->orWhere('email', 'like', "%$s%");
        }

        return response()->json($query->orderByDesc('created_at')->paginate(20));
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'store_name'      => 'required|string|max:255',
            'email'           => 'nullable|email|max:255',
            'phone'           => 'nullable|string|max:50',
            'description'     => 'nullable|string',
            'address'         => 'nullable|string',
            'logo'            => 'nullable|string',
            'banner'          => 'nullable|string',
            'commission_rate' => 'nullable|numeric|min:0|max:100',
            'is_active'       => 'boolean',
        ]);

        return response()->json(Vendor::create($data), 201);
    }

    public function update(Request $request, $id)
    {
        $vendor = Vendor::findOrFail($id);

        $data = $request->validate([
            'store_name'      => 'sometimes|required|string|max:255',
            'email'           => 'nullable|email|max:255',
            'phone'           => 'nullable|string|max:50',
            'description'     => 'nullable|string',
            'address'         => 'nullable|string',
            'logo'            => 'nullable|string',
            'banner'          => 'nullable|string',
            'commission_rate' => 'nullable|numeric|min:0|max:100',
            'is_active'       => 'boolean',
        ]);

        $vendor->update($data);

        return response()->json($vendor);
    }

    public function destroy($id)
    {
        $vendor = Vendor::findOrFail($id);
        $vendor->delete();

        return response()->json(['message' => 'Vendor deleted']);
    }
}
