<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;

class UserAdminController extends Controller
{
    public function index(Request $request)
    {
        $query = User::query();

        if ($s = $request->search) {
            $query->where(function ($q) use ($s) {
                $q->where('name', 'like', "%$s%")
                  ->orWhere('email', 'like', "%$s%");
            });
        }

        return response()->json($query->orderByDesc('created_at')->paginate(20));
    }

    public function show($id)
    {
        return response()->json(User::findOrFail($id));
    }

    public function toggleAdmin($id)
    {
        $user = User::findOrFail($id);

        // Prevent removing own admin status
        if ($user->id === auth()->id()) {
            return response()->json(['message' => 'Cannot modify your own admin status'], 422);
        }

        $user->update(['is_admin' => !$user->is_admin]);

        return response()->json($user);
    }
}
