<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class UploadController extends Controller
{
    public function upload(Request $request)
    {
        $request->validate([
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,webp|max:5120', // 5MB max
        ]);

        $file      = $request->file('image');
        $filename  = Str::uuid() . '.' . $file->getClientOriginalExtension();
        $path      = $file->storeAs('uploads/products', $filename, 'public');

        $url = config('app.url') . '/storage/' . $path;

        return response()->json([
            'url'  => $url,
            'path' => $path,
            'name' => $file->getClientOriginalName(),
            'size' => $file->getSize(),
        ]);
    }

    public function delete(Request $request)
    {
        $data = $request->validate(['path' => 'required|string']);

        // Only allow deleting from our uploads folder
        if (!str_starts_with($data['path'], 'uploads/')) {
            return response()->json(['message' => 'Forbidden'], 403);
        }

        Storage::disk('public')->delete($data['path']);

        return response()->json(['message' => 'Deleted']);
    }
}
