<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Models\Product;
use App\Models\User;
use App\Models\WholesaleApplication;
use App\Models\Contact;
use App\Models\Review;
use Illuminate\Support\Facades\DB;

class StatsController extends Controller
{
    public function index()
    {
        $totalRevenue = Order::where('payment_status', 'paid')->sum('total');
        $totalOrders  = Order::count();
        $totalUsers   = User::where('is_admin', false)->count();
        $totalProducts = Product::count();

        $pendingOrders    = Order::where('status', 'pending')->count();
        $pendingWholesale = WholesaleApplication::where('status', 'pending')->count();
        $unreadContacts   = Contact::where('is_read', false)->count();
        $pendingReviews   = Review::where('is_approved', false)->count();

        // Revenue last 7 days
        $revenueChart = collect(range(6, 0))->map(function ($daysAgo) {
            $date = now()->subDays($daysAgo)->toDateString();
            $revenue = Order::where('payment_status', 'paid')
                ->whereDate('created_at', $date)
                ->sum('total');
            return [
                'date'    => now()->subDays($daysAgo)->format('M j'),
                'revenue' => (float) $revenue,
            ];
        });

        // Top 5 products by sales
        $topProducts = Product::select('products.*')
            ->withCount(['orderItems as sales_count'])
            ->orderByDesc('sales_count')
            ->limit(5)
            ->get(['id', 'name', 'price', 'rating', 'sales_count']);

        // Recent 10 orders
        $recentOrders = Order::with('user:id,name,email')
            ->orderByDesc('created_at')
            ->limit(10)
            ->get(['id', 'order_number', 'user_id', 'shipping_name', 'total', 'status', 'created_at']);

        return response()->json([
            'total_revenue'    => $totalRevenue,
            'total_orders'     => $totalOrders,
            'total_users'      => $totalUsers,
            'total_products'   => $totalProducts,
            'pending_orders'   => $pendingOrders,
            'pending_wholesale' => $pendingWholesale,
            'unread_contacts'  => $unreadContacts,
            'pending_reviews'  => $pendingReviews,
            'revenue_chart'    => $revenueChart,
            'top_products'     => $topProducts,
            'recent_orders'    => $recentOrders,
        ]);
    }
}
