<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Slider;
use App\Models\Banner;
use Illuminate\Http\Request;

class SliderAdminController extends Controller
{
    // --- Sliders ---

    public function indexSliders()
    {
        return response()->json(Slider::orderBy('sort_order')->get());
    }

    public function storeSlider(Request $request)
    {
        $data = $request->validate([
            'title'       => 'nullable|string|max:255',
            'subtitle'    => 'nullable|string|max:255',
            'image'       => 'required|string',
            'link'        => 'nullable|string',
            'button_text' => 'nullable|string|max:100',
            'sort_order'  => 'integer|min:0',
            'is_active'   => 'boolean',
        ]);

        return response()->json(Slider::create($data), 201);
    }

    public function updateSlider(Request $request, $id)
    {
        $slider = Slider::findOrFail($id);

        $data = $request->validate([
            'title'       => 'nullable|string|max:255',
            'subtitle'    => 'nullable|string|max:255',
            'image'       => 'nullable|string',
            'link'        => 'nullable|string',
            'button_text' => 'nullable|string|max:100',
            'sort_order'  => 'integer|min:0',
            'is_active'   => 'boolean',
        ]);

        $slider->update($data);

        return response()->json($slider);
    }

    public function destroySlider($id)
    {
        Slider::findOrFail($id)->delete();
        return response()->json(['message' => 'Slider deleted']);
    }

    // --- Banners ---

    public function indexBanners()
    {
        return response()->json(Banner::orderBy('sort_order')->get());
    }

    public function storeBanner(Request $request)
    {
        $data = $request->validate([
            'title'      => 'nullable|string|max:255',
            'subtitle'   => 'nullable|string|max:255',
            'image'      => 'required|string',
            'link'       => 'nullable|string',
            'position'   => 'nullable|string|max:50',
            'sort_order' => 'integer|min:0',
            'is_active'  => 'boolean',
        ]);

        return response()->json(Banner::create($data), 201);
    }

    public function updateBanner(Request $request, $id)
    {
        $banner = Banner::findOrFail($id);

        $data = $request->validate([
            'title'      => 'nullable|string|max:255',
            'subtitle'   => 'nullable|string|max:255',
            'image'      => 'nullable|string',
            'link'       => 'nullable|string',
            'position'   => 'nullable|string|max:50',
            'sort_order' => 'integer|min:0',
            'is_active'  => 'boolean',
        ]);

        $banner->update($data);

        return response()->json($banner);
    }

    public function destroyBanner($id)
    {
        Banner::findOrFail($id)->delete();
        return response()->json(['message' => 'Banner deleted']);
    }
}
