<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;

class SettingAdminController extends Controller
{
    public function index()
    {
        $settings = Setting::pluck('value', 'key');

        // Decode JSON values
        $decoded = $settings->map(function ($val) {
            $json = json_decode($val, true);
            return $json !== null ? $json : $val;
        });

        return response()->json($decoded);
    }

    public function update(Request $request)
    {
        $data = $request->all();

        foreach ($data as $key => $value) {
            $stored = is_array($value) || is_bool($value) ? json_encode($value) : (string) $value;
            Setting::updateOrCreate(
                ['key' => $key],
                ['value' => $stored]
            );
        }

        return response()->json(['message' => 'Settings updated']);
    }
}
