<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Contact;
use App\Models\Newsletter;
use Illuminate\Http\Request;

class ContactAdminController extends Controller
{
    public function index(Request $request)
    {
        $query = Contact::query();

        if ($request->status === 'unread') {
            $query->where('is_read', false);
        } elseif ($request->status === 'read') {
            $query->where('is_read', true);
        }

        return response()->json($query->orderByDesc('created_at')->paginate(20));
    }

    public function markRead($id)
    {
        $contact = Contact::findOrFail($id);
        $contact->update(['is_read' => true]);

        return response()->json($contact);
    }

    public function newsletter(Request $request)
    {
        $query = Newsletter::query();

        if ($s = $request->search) {
            $query->where('email', 'like', "%$s%")
                  ->orWhere('name', 'like', "%$s%");
        }

        return response()->json($query->orderByDesc('created_at')->paginate(20));
    }
}
