import axios from 'axios'

const api = axios.create({
  baseURL: '/api/v1',
  headers: { 'Content-Type': 'application/json', 'Accept': 'application/json' },
})

api.interceptors.request.use((config) => {
  const token = localStorage.getItem('admin_token')
  if (token) config.headers.Authorization = `Bearer ${token}`
  return config
})

api.interceptors.response.use(
  (r) => r,
  (err) => {
    if (err.response?.status === 401) {
      localStorage.removeItem('admin_token')
      localStorage.removeItem('admin_user')
      window.location.href = '/login'
    }
    return Promise.reject(err)
  }
)

// Auth
export const adminLogin = (data) => api.post('/auth/login', data)
export const adminLogout = () => api.post('/auth/logout')

// Stats
export const getStats = () => api.get('/admin/stats')

// Products
export const adminGetProducts = (p) => api.get('/admin/products', { params: p })
export const adminGetProduct = (id) => api.get(`/admin/products/${id}`)
export const adminCreateProduct = (data) => api.post('/admin/products', data)
export const adminUpdateProduct = (id, data) => api.put(`/admin/products/${id}`, data)
export const adminDeleteProduct = (id) => api.delete(`/admin/products/${id}`)

// Categories
export const adminGetCategories = () => api.get('/admin/categories')
export const adminCreateCategory = (data) => api.post('/admin/categories', data)
export const adminUpdateCategory = (id, data) => api.put(`/admin/categories/${id}`, data)
export const adminDeleteCategory = (id) => api.delete(`/admin/categories/${id}`)

// Orders
export const adminGetOrders = (p) => api.get('/admin/orders', { params: p })
export const adminGetOrder = (id) => api.get(`/admin/orders/${id}`)
export const adminUpdateOrderStatus = (id, data) => api.put(`/admin/orders/${id}`, data)

// Users
export const adminGetUsers = (p) => api.get('/admin/users', { params: p })
export const adminGetUser = (id) => api.get(`/admin/users/${id}`)
export const adminToggleAdmin = (id) => api.put(`/admin/users/${id}/toggle-admin`)

// Vendors
export const adminGetVendors = (p) => api.get('/admin/vendors', { params: p })
export const adminCreateVendor = (data) => api.post('/admin/vendors', data)
export const adminUpdateVendor = (id, data) => api.put(`/admin/vendors/${id}`, data)
export const adminDeleteVendor = (id) => api.delete(`/admin/vendors/${id}`)

// Sliders
export const adminGetSliders = () => api.get('/admin/sliders')
export const adminCreateSlider = (data) => api.post('/admin/sliders', data)
export const adminUpdateSlider = (id, data) => api.put(`/admin/sliders/${id}`, data)
export const adminDeleteSlider = (id) => api.delete(`/admin/sliders/${id}`)

// Banners
export const adminGetBanners = () => api.get('/admin/banners')
export const adminCreateBanner = (data) => api.post('/admin/banners', data)
export const adminUpdateBanner = (id, data) => api.put(`/admin/banners/${id}`, data)
export const adminDeleteBanner = (id) => api.delete(`/admin/banners/${id}`)

// Settings
export const adminGetSettings = () => api.get('/admin/settings')
export const adminUpdateSettings = (data) => api.put('/admin/settings', data)

// Wholesale
export const adminGetWholesale = (p) => api.get('/admin/wholesale', { params: p })
export const adminUpdateWholesale = (id, data) => api.put(`/admin/wholesale/${id}`, data)

// Coupons
export const adminGetCoupons = () => api.get('/admin/coupons')
export const adminCreateCoupon = (data) => api.post('/admin/coupons', data)
export const adminUpdateCoupon = (id, data) => api.put(`/admin/coupons/${id}`, data)
export const adminDeleteCoupon = (id) => api.delete(`/admin/coupons/${id}`)

// Reviews
export const adminGetReviews = (p) => api.get('/admin/reviews', { params: p })
export const adminApproveReview = (id) => api.put(`/admin/reviews/${id}/approve`)
export const adminDeleteReview = (id) => api.delete(`/admin/reviews/${id}`)

// Newsletter
export const adminGetNewsletter = (p) => api.get('/admin/newsletter', { params: p })

// Contacts
export const adminGetContacts = (p) => api.get('/admin/contacts', { params: p })
export const adminMarkContactRead = (id) => api.put(`/admin/contacts/${id}/read`)

// Image Upload
export const adminUploadImage = (file) => {
  const formData = new FormData()
  formData.append('image', file)
  return api.post('/admin/upload', formData, {
    headers: { 'Content-Type': 'multipart/form-data' },
  })
}
export const adminDeleteUpload = (path) => api.delete('/admin/upload', { data: { path } })

export default api
