import { useState } from 'react'
import { useNavigate } from 'react-router-dom'
import { useAuth } from '../context/AuthContext'

const Login = () => {
  const [form, setForm] = useState({ email: '', password: '' })
  const [error, setError] = useState('')
  const { login, loading } = useAuth()
  const navigate = useNavigate()

  const handleSubmit = async (e) => {
    e.preventDefault()
    setError('')
    try {
      await login(form.email, form.password)
      navigate('/', { replace: true })
    } catch (err) {
      setError(err.message || err.response?.data?.message || 'Login failed')
    }
  }

  return (
    <div className="min-vh-100 d-flex align-items-center justify-content-center" style={{ background: '#f0f2f5' }}>
      <div style={{ width: '100%', maxWidth: 420, padding: '0 16px' }}>
        <div className="text-center mb-4">
          <div className="d-inline-flex align-items-center justify-content-center mb-3"
            style={{ width: 56, height: 56, background: 'linear-gradient(135deg, #4e9af1, #2563eb)', borderRadius: 16 }}>
            <span style={{ color: '#fff', fontSize: '1.6rem', fontWeight: 900 }}>K</span>
          </div>
          <h4 className="fw-bold mb-1">Kalses Admin</h4>
          <p className="text-muted" style={{ fontSize: '.875rem' }}>Sign in to your admin panel</p>
        </div>
        <div className="card border-0 shadow-sm">
          <div className="card-body p-4">
            {error && (
              <div className="alert alert-danger py-2 mb-3" style={{ fontSize: '.875rem' }}>
                <i className="bi bi-exclamation-circle me-1"></i>{error}
              </div>
            )}
            <form onSubmit={handleSubmit}>
              <div className="mb-3">
                <label className="form-label fw-semibold" style={{ fontSize: '.875rem' }}>Email</label>
                <input className="form-control" type="email" placeholder="admin@kalses.com"
                  value={form.email} onChange={e => setForm(f => ({ ...f, email: e.target.value }))} required />
              </div>
              <div className="mb-4">
                <label className="form-label fw-semibold" style={{ fontSize: '.875rem' }}>Password</label>
                <input className="form-control" type="password" placeholder="••••••••"
                  value={form.password} onChange={e => setForm(f => ({ ...f, password: e.target.value }))} required />
              </div>
              <button className="btn btn-primary w-100" type="submit" disabled={loading}>
                {loading ? <><span className="spinner-border spinner-border-sm me-2"></span>Signing in...</> : 'Sign In'}
              </button>
            </form>
          </div>
        </div>
        <p className="text-center text-muted mt-3" style={{ fontSize: '.8rem' }}>
          Only admin accounts can access this panel.
        </p>
      </div>
    </div>
  )
}
export default Login
