const Confirm = ({ show, message, onConfirm, onCancel }) => {
  if (!show) return null
  return (
    <div className="modal d-block" style={{ background: 'rgba(0,0,0,.5)' }}>
      <div className="modal-dialog modal-sm modal-dialog-centered">
        <div className="modal-content">
          <div className="modal-body text-center p-4">
            <i className="bi bi-exclamation-triangle text-warning" style={{ fontSize: '2rem' }}></i>
            <p className="mt-2 mb-0">{message || 'Are you sure?'}</p>
          </div>
          <div className="modal-footer justify-content-center border-0 pt-0">
            <button className="btn btn-sm btn-secondary" onClick={onCancel}>Cancel</button>
            <button className="btn btn-sm btn-danger" onClick={onConfirm}>Delete</button>
          </div>
        </div>
      </div>
    </div>
  )
}
export default Confirm
