import { NavLink } from 'react-router-dom'
import { useAuth } from '../../context/AuthContext'

const NAV = [
  { section: 'Main' },
  { to: '/', icon: 'bi-speedometer2', label: 'Dashboard' },
  { section: 'Catalog' },
  { to: '/products', icon: 'bi-box-seam', label: 'Products' },
  { to: '/categories', icon: 'bi-tag', label: 'Categories' },
  { to: '/vendors', icon: 'bi-shop', label: 'Vendors' },
  { section: 'Sales' },
  { to: '/orders', icon: 'bi-cart-check', label: 'Orders' },
  { to: '/coupons', icon: 'bi-ticket-perforated', label: 'Coupons' },
  { section: 'Content' },
  { to: '/homepage', icon: 'bi-house-gear', label: 'Home Page' },
  { to: '/sliders', icon: 'bi-images', label: 'Sliders' },
  { to: '/banners', icon: 'bi-image', label: 'Banners' },
  { section: 'Users' },
  { to: '/users', icon: 'bi-people', label: 'Users' },
  { to: '/wholesale', icon: 'bi-building', label: 'Wholesale' },
  { to: '/reviews', icon: 'bi-star', label: 'Reviews' },
  { section: 'Communication' },
  { to: '/contacts', icon: 'bi-envelope', label: 'Contacts' },
  { to: '/newsletter', icon: 'bi-megaphone', label: 'Newsletter' },
  { section: 'System' },
  { to: '/settings', icon: 'bi-gear', label: 'Settings' },
]

const Sidebar = ({ open, onClose }) => {
  const { user, logout } = useAuth()
  return (
    <aside className={`sidebar${open ? ' open' : ''}`}>
      <div className="sidebar-brand">
        <div className="d-flex align-items-center gap-2">
          <div className="sidebar-logo">K</div>
          <div>
            <h4 className="mb-0">Kalses</h4>
            <small>Admin Panel</small>
          </div>
        </div>
      </div>
      <nav className="sidebar-nav">
        {NAV.map((item, i) =>
          item.section ? (
            <div key={i} className="nav-section">{item.section}</div>
          ) : (
            <NavLink key={i} to={item.to} end={item.to === '/'} onClick={onClose}>
              <i className={`bi ${item.icon}`}></i>
              {item.label}
            </NavLink>
          )
        )}
      </nav>
      <div className="sidebar-footer">
        <div className="d-flex align-items-center gap-2 mb-3">
          <div className="sidebar-avatar">
            {user?.name?.[0]?.toUpperCase()}
          </div>
          <div className="overflow-hidden">
            <div className="text-white fw-semibold" style={{ fontSize: '.8rem', whiteSpace: 'nowrap', overflow: 'hidden', textOverflow: 'ellipsis' }}>{user?.name}</div>
            <div style={{ fontSize: '.7rem', color: '#6c757d' }}>Administrator</div>
          </div>
        </div>
        <button className="btn btn-outline-danger btn-sm w-100" onClick={logout}>
          <i className="bi bi-box-arrow-right me-1"></i>Logout
        </button>
      </div>
    </aside>
  )
}
export default Sidebar
