import { useState } from 'react'
import { Outlet, Navigate } from 'react-router-dom'
import Sidebar from './Sidebar'
import Topbar from './Topbar'
import { useAuth } from '../../context/AuthContext'

const Layout = () => {
  const { isLoggedIn } = useAuth()
  const [sidebarOpen, setSidebarOpen] = useState(false)

  if (!isLoggedIn) return <Navigate to="/login" replace />

  return (
    <>
      {sidebarOpen && (
        <div className="sidebar-overlay" onClick={() => setSidebarOpen(false)} />
      )}
      <Sidebar open={sidebarOpen} onClose={() => setSidebarOpen(false)} />
      <div className="layout-body">
        <Topbar onToggle={() => setSidebarOpen(o => !o)} />
        <main className="main-content">
          <Outlet />
        </main>
      </div>
    </>
  )
}
export default Layout
